/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.PathNumOverLimitException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.ILogicalOptimizer;
import org.apache.iotdb.db.query.udf.core.context.UDFContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatPathOptimizer
implements ILogicalOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(ConcatPathOptimizer.class);
    private static final String WARNING_NO_SUFFIX_PATHS = "given SFWOperator doesn't have suffix paths, cannot concat seriesPath";
    private static final String WARNING_NO_PREFIX_PATHS = "given SFWOperator doesn't have prefix paths, cannot concat seriesPath";

    @Override
    public Operator transform(Operator operator) throws LogicalOptimizeException, PathNumOverLimitException {
        if (!(operator instanceof SFWOperator)) {
            logger.warn("given operator isn't SFWOperator, cannot concat seriesPath");
            return operator;
        }
        SFWOperator sfwOperator = (SFWOperator)operator;
        FromOperator from = sfwOperator.getFromOperator();
        if (from == null) {
            logger.warn(WARNING_NO_PREFIX_PATHS);
            return operator;
        }
        List<PartialPath> prefixPaths = from.getPrefixPaths();
        if (prefixPaths.isEmpty()) {
            logger.warn(WARNING_NO_PREFIX_PATHS);
            return operator;
        }
        SelectOperator select = sfwOperator.getSelectOperator();
        if (select == null) {
            logger.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        List<PartialPath> initialSuffixPaths = select.getSuffixPaths();
        if (initialSuffixPaths.isEmpty()) {
            logger.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        this.checkAggrOfSelectOperator(select);
        boolean isAlignByDevice = false;
        if (operator instanceof QueryOperator) {
            if (!((QueryOperator)operator).isAlignByDevice() || ((QueryOperator)operator).isLastQuery()) {
                int seriesLimit = ((QueryOperator)operator).getSeriesLimit();
                int seriesOffset = ((QueryOperator)operator).getSeriesOffset();
                this.concatSelect(prefixPaths, select, seriesLimit, seriesOffset, ((QueryOperator)operator).getIndexType() == null);
            } else {
                isAlignByDevice = true;
                if (((QueryOperator)operator).hasUdf()) {
                    throw new LogicalOptimizeException("ALIGN BY DEVICE clause is not supported in UDF queries.");
                }
                for (PartialPath path : initialSuffixPaths) {
                    String device = path.getDevice();
                    if (device.isEmpty()) continue;
                    throw new LogicalOptimizeException("The paths of the SELECT clause can only be single level. In other words, the paths of the SELECT clause can only be measurements or STAR, without DOT. For more details please refer to the SQL document.");
                }
            }
        }
        FilterOperator filter = sfwOperator.getFilterOperator();
        HashSet<PartialPath> filterPaths = new HashSet<PartialPath>();
        if (filter == null) {
            return operator;
        }
        if (!isAlignByDevice) {
            sfwOperator.setFilterOperator(this.concatFilter(prefixPaths, filter, filterPaths));
        }
        sfwOperator.getFilterOperator().setPathSet(filterPaths);
        return sfwOperator;
    }

    private List<PartialPath> judgeSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (selectOperator == null) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        List<PartialPath> suffixPaths = selectOperator.getSuffixPaths();
        if (suffixPaths.isEmpty()) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        return suffixPaths;
    }

    private void checkAggrOfSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (!selectOperator.getAggregations().isEmpty() && selectOperator.getSuffixPaths().size() != selectOperator.getAggregations().size()) {
            throw new LogicalOptimizeException("Common queries and aggregated queries are not allowed to appear at the same time");
        }
    }

    private void extendListSafely(List<String> source, int index, List<String> target) {
        if (source != null && !source.isEmpty()) {
            target.add(source.get(index));
        }
    }

    private void concatSelect(List<PartialPath> fromPaths, SelectOperator selectOperator, int limit, int offset, boolean needRemoveStar) throws LogicalOptimizeException, PathNumOverLimitException {
        List<PartialPath> suffixPaths = this.judgeSelectOperator(selectOperator);
        ArrayList<PartialPath> afterConcatPaths = new ArrayList<PartialPath>();
        List<String> originAggregations = selectOperator.getAggregations();
        ArrayList<String> afterConcatAggregations = new ArrayList<String>();
        List<UDFContext> originUdfList = selectOperator.getUdfList();
        ArrayList<UDFContext> afterConcatUdfList = new ArrayList<UDFContext>();
        for (int i = 0; i < suffixPaths.size(); ++i) {
            PartialPath selectPath = suffixPaths.get(i);
            if (selectPath == null) {
                UDFContext originUdf = originUdfList.get(i);
                List<PartialPath> originUdfSuffixPaths = originUdf.getPaths();
                ArrayList<List<PartialPath>> afterConcatUdfPathsList = new ArrayList<List<PartialPath>>();
                for (PartialPath originUdfSuffixPath : originUdfSuffixPaths) {
                    ArrayList<PartialPath> arrayList = new ArrayList<PartialPath>();
                    for (PartialPath fromPath : fromPaths) {
                        arrayList.add(fromPath.concatPath(originUdfSuffixPath));
                    }
                    afterConcatUdfPathsList.add(arrayList);
                }
                ArrayList<List<PartialPath>> extendedAfterConcatUdfPathsList = new ArrayList<List<PartialPath>>();
                ConcatPathOptimizer.cartesianProduct(afterConcatUdfPathsList, extendedAfterConcatUdfPathsList, 0, new ArrayList<PartialPath>());
                for (List list : extendedAfterConcatUdfPathsList) {
                    afterConcatPaths.add(null);
                    this.extendListSafely(originAggregations, i, afterConcatAggregations);
                    afterConcatUdfList.add(new UDFContext(originUdf.getName(), originUdf.getAttributes(), list));
                }
                continue;
            }
            for (PartialPath fromPath : fromPaths) {
                PartialPath fullPath = fromPath.concatPath(selectPath);
                if (selectPath.isTsAliasExists()) {
                    fullPath.setTsAlias(selectPath.getTsAlias());
                }
                afterConcatPaths.add(fullPath);
                this.extendListSafely(originAggregations, i, afterConcatAggregations);
                afterConcatUdfList.add(null);
            }
        }
        if (needRemoveStar) {
            this.removeStarsInPath(afterConcatPaths, afterConcatAggregations, afterConcatUdfList, selectOperator, limit, offset);
        } else {
            selectOperator.setSuffixPathList(afterConcatPaths);
        }
    }

    private FilterOperator concatFilter(List<PartialPath> fromPaths, FilterOperator operator, Set<PartialPath> filterPaths) throws LogicalOptimizeException {
        if (!operator.isLeaf()) {
            ArrayList<FilterOperator> newFilterList = new ArrayList<FilterOperator>();
            for (FilterOperator child : operator.getChildren()) {
                newFilterList.add(this.concatFilter(fromPaths, child, filterPaths));
            }
            operator.setChildren(newFilterList);
            return operator;
        }
        FunctionOperator functionOperator = (FunctionOperator)operator;
        PartialPath filterPath = functionOperator.getSinglePath();
        if (SQLConstant.isReservedPath(filterPath) || filterPath.getFirstNode().startsWith("root")) {
            filterPaths.add(filterPath);
            return operator;
        }
        ArrayList<PartialPath> concatPaths = new ArrayList<PartialPath>();
        fromPaths.forEach(fromPath -> concatPaths.add(fromPath.concatPath(filterPath)));
        List<PartialPath> noStarPaths = this.removeStarsInPathWithUnique(concatPaths);
        filterPaths.addAll(noStarPaths);
        if (noStarPaths.size() == 1) {
            functionOperator.setSinglePath(noStarPaths.get(0));
            return operator;
        }
        return this.constructBinaryFilterTreeWithAnd(noStarPaths, operator);
    }

    private FilterOperator constructBinaryFilterTreeWithAnd(List<PartialPath> noStarPaths, FilterOperator operator) throws LogicalOptimizeException {
        FilterOperator filterBinaryTree;
        FilterOperator currentNode = filterBinaryTree = new FilterOperator(1);
        for (int i = 0; i < noStarPaths.size(); ++i) {
            if (i > 0 && i < noStarPaths.size() - 1) {
                FilterOperator newInnerNode = new FilterOperator(1);
                currentNode.addChildOperator(newInnerNode);
                currentNode = newInnerNode;
            }
            try {
                if (operator instanceof InOperator) {
                    currentNode.addChildOperator(new InOperator(operator.getTokenIntType(), noStarPaths.get(i), ((InOperator)operator).getNot(), ((InOperator)operator).getValues()));
                    continue;
                }
                currentNode.addChildOperator(new BasicFunctionOperator(operator.getTokenIntType(), noStarPaths.get(i), ((BasicFunctionOperator)operator).getValue()));
                continue;
            }
            catch (SQLParserException e) {
                throw new LogicalOptimizeException(e.getMessage());
            }
        }
        return filterBinaryTree;
    }

    private List<PartialPath> removeStarsInPathWithUnique(List<PartialPath> paths) throws LogicalOptimizeException {
        ArrayList<PartialPath> retPaths = new ArrayList<PartialPath>();
        HashSet<PartialPath> pathSet = new HashSet<PartialPath>();
        try {
            for (PartialPath path : paths) {
                List all = (List)this.removeWildcard((PartialPath)path, (int)0, (int)0).left;
                if (all.size() == 0) {
                    throw new LogicalOptimizeException(String.format("Unknown time series %s in `where clause`", path));
                }
                for (PartialPath subPath : all) {
                    if (pathSet.contains(subPath)) continue;
                    pathSet.add(subPath);
                    retPaths.add(subPath);
                }
            }
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
        }
        return retPaths;
    }

    private void removeStarsInPath(List<PartialPath> afterConcatPaths, List<String> afterConcatAggregations, List<UDFContext> afterConcatUdfList, SelectOperator selectOperator, int finalLimit, int finalOffset) throws LogicalOptimizeException, PathNumOverLimitException {
        int offset = finalOffset;
        int limit = finalLimit == 0 ? Integer.MAX_VALUE : finalLimit;
        int consumed = 0;
        ArrayList<PartialPath> newSuffixPathList = new ArrayList<PartialPath>();
        ArrayList<String> newAggregations = new ArrayList<String>();
        ArrayList<UDFContext> newUdfList = new ArrayList<UDFContext>();
        for (int i = 0; i < afterConcatPaths.size(); ++i) {
            try {
                PartialPath afterConcatPath = afterConcatPaths.get(i);
                if (afterConcatPath == null) {
                    UDFContext originUdf = afterConcatUdfList.get(i);
                    List<PartialPath> originPaths = originUdf.getPaths();
                    ArrayList extendedPaths = new ArrayList();
                    boolean atLeastOneSeriesNotExisted = false;
                    for (PartialPath originPath : originPaths) {
                        List list = (List)this.removeWildcard((PartialPath)originPath, (int)0, (int)0).left;
                        if (list.isEmpty()) {
                            atLeastOneSeriesNotExisted = true;
                            break;
                        }
                        this.checkAndSetTsAlias(list, originPath);
                        extendedPaths.add(list);
                    }
                    if (atLeastOneSeriesNotExisted) continue;
                    ArrayList<List<PartialPath>> actualPaths = new ArrayList<List<PartialPath>>();
                    ConcatPathOptimizer.cartesianProduct(extendedPaths, actualPaths, 0, new ArrayList<PartialPath>());
                    for (List list : actualPaths) {
                        if (offset != 0) {
                            --offset;
                            continue;
                        }
                        if (limit != 0) {
                            --limit;
                            newSuffixPathList.add(null);
                            this.extendListSafely(afterConcatAggregations, i, newAggregations);
                            newUdfList.add(new UDFContext(originUdf.getName(), originUdf.getAttributes(), list));
                            continue;
                        }
                        break;
                    }
                } else {
                    Pair<List<PartialPath>, Integer> pair = this.removeWildcard(afterConcatPath, limit, offset);
                    List actualPaths = (List)pair.left;
                    this.checkAndSetTsAlias(actualPaths, afterConcatPath);
                    for (PartialPath actualPath : actualPaths) {
                        newSuffixPathList.add(actualPath);
                        this.extendListSafely(afterConcatAggregations, i, newAggregations);
                        newUdfList.add(null);
                    }
                    consumed += ((Integer)pair.right).intValue();
                    if (offset != 0) {
                        int delta = offset - (Integer)pair.right;
                        offset = Math.max(delta, 0);
                        if (delta < 0) {
                            limit += delta;
                        }
                    } else {
                        limit -= ((Integer)pair.right).intValue();
                    }
                }
                if (limit != 0) continue;
                int maxDeduplicatedPathNum = IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum();
                if (maxDeduplicatedPathNum >= newSuffixPathList.size()) break;
                throw new PathNumOverLimitException(maxDeduplicatedPathNum);
            }
            catch (MetadataException e) {
                throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
            }
        }
        if (consumed == 0 ? finalOffset != 0 : newSuffixPathList.isEmpty()) {
            throw new LogicalOptimizeException(String.format("The value of SOFFSET (%d) is equal to or exceeds the number of sequences (%d) that can actually be returned.", finalOffset, consumed));
        }
        selectOperator.setSuffixPathList(newSuffixPathList);
        selectOperator.setAggregations(newAggregations);
        selectOperator.setUdfList(newUdfList);
    }

    protected Pair<List<PartialPath>, Integer> removeWildcard(PartialPath path, int limit, int offset) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesPathWithAlias(path, limit, offset);
    }

    private void checkAndSetTsAlias(List<PartialPath> actualPaths, PartialPath originPath) throws LogicalOptimizeException {
        if (originPath.isTsAliasExists()) {
            if (actualPaths.size() == 1) {
                actualPaths.get(0).setTsAlias(originPath.getTsAlias());
            } else if (actualPaths.size() >= 2) {
                throw new LogicalOptimizeException("alias '" + originPath.getTsAlias() + "' can only be matched with one time series");
            }
        }
    }

    private static void cartesianProduct(List<List<PartialPath>> dimensionValue, List<List<PartialPath>> resultList, int layer, List<PartialPath> currentList) {
        block7: {
            block6: {
                if (layer >= dimensionValue.size() - 1) break block6;
                if (dimensionValue.get(layer).isEmpty()) {
                    ConcatPathOptimizer.cartesianProduct(dimensionValue, resultList, layer + 1, currentList);
                } else {
                    for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                        ArrayList<PartialPath> list = new ArrayList<PartialPath>(currentList);
                        list.add(dimensionValue.get(layer).get(i));
                        ConcatPathOptimizer.cartesianProduct(dimensionValue, resultList, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimensionValue.size() - 1) break block7;
            if (dimensionValue.get(layer).isEmpty()) {
                resultList.add(currentList);
            } else {
                for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                    ArrayList<PartialPath> list = new ArrayList<PartialPath>(currentList);
                    list.add(dimensionValue.get(layer).get(i));
                    resultList.add(list);
                }
            }
        }
    }
}

