/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.TracingInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingManager {
    private static final Logger logger = LoggerFactory.getLogger(TracingManager.class);
    private static final String QUERY_ID = "Query Id: %d";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private BufferedWriter writer;
    private Map<Long, Long> queryStartTime = new ConcurrentHashMap<Long, Long>();
    private Map<Long, TracingInfo> tracingInfoMap = new ConcurrentHashMap<Long, TracingInfo>();

    public TracingManager(String dirName, String logFileName) {
        this.initTracingManager(dirName, logFileName);
    }

    public void initTracingManager(String dirName, String logFileName) {
        File tracingDir = SystemFileFactory.INSTANCE.getFile(dirName);
        if (!tracingDir.exists()) {
            if (tracingDir.mkdirs()) {
                logger.info("create performance folder {}.", (Object)tracingDir);
            } else {
                logger.info("create performance folder {} failed.", (Object)tracingDir);
            }
        }
        File logFile = SystemFileFactory.INSTANCE.getFile(dirName + File.separator + logFileName);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            logger.error("Meeting error while creating TracingManager: {}", (Object)e.getMessage());
        }
        this.writer = new BufferedWriter(fileWriter);
    }

    public static TracingManager getInstance() {
        return TracingManagerHelper.INSTANCE;
    }

    public TracingInfo getTracingInfo(long queryId) {
        return this.tracingInfoMap.computeIfAbsent(queryId, k -> new TracingInfo());
    }

    public void writeQueryInfo(long queryId, String statement, long startTime, int pathsNum) throws IOException {
        this.queryStartTime.put(queryId, startTime);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(QUERY_ID, queryId)).append(String.format(" - Query Statement: %s", statement)).append("\n").append(String.format(QUERY_ID, queryId)).append(" - Start time: ").append(new SimpleDateFormat(DATE_FORMAT).format(startTime)).append("\n").append(String.format(QUERY_ID, queryId)).append(String.format(" - Number of series paths: %d", pathsNum)).append("\n");
        this.writer.write(builder.toString());
    }

    public void writeQueryInfo(long queryId, String statement, long startTime) throws IOException {
        this.queryStartTime.put(queryId, startTime);
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(QUERY_ID, queryId)).append(String.format(" - Query Statement: %s", statement)).append("\n").append(String.format(QUERY_ID, queryId)).append(" - Start time: ").append(new SimpleDateFormat(DATE_FORMAT).format(startTime)).append("\n");
        this.writer.write(builder.toString());
    }

    public void writePathsNum(long queryId, int pathsNum) throws IOException {
        StringBuilder builder = new StringBuilder(String.format(QUERY_ID, queryId)).append(String.format(" - Number of series paths: %d", pathsNum)).append("\n");
        this.writer.write(builder.toString());
    }

    public void writeTracingInfo(long queryId) throws IOException {
        TracingInfo tracingInfo = this.tracingInfoMap.get(queryId);
        this.writeTsFileInfo(queryId, tracingInfo.getSeqFileSet(), tracingInfo.getUnSeqFileSet());
        this.writeChunksInfo(queryId, tracingInfo.getTotalChunkNum(), tracingInfo.getTotalChunkPoints());
        this.writeOverlappedPageInfo(queryId, tracingInfo.getTotalPageNum(), tracingInfo.getOverlappedPageNum());
    }

    public void writeTsFileInfo(long queryId, Set<TsFileResource> seqFileResources, Set<TsFileResource> unSeqFileResources) throws IOException {
        StringBuilder builder = new StringBuilder(String.format(QUERY_ID, queryId)).append(String.format(" - Number of sequence files: %d", seqFileResources.size()));
        if (!seqFileResources.isEmpty()) {
            builder.append("\n").append(String.format(QUERY_ID, queryId)).append(" - SeqFiles: ");
            Iterator<TsFileResource> seqFileIterator = seqFileResources.iterator();
            while (seqFileIterator.hasNext()) {
                builder.append(seqFileIterator.next().getTsFile().getName());
                if (!seqFileIterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        builder.append("\n").append(String.format(QUERY_ID, queryId)).append(String.format(" - Number of unSequence files: %d", unSeqFileResources.size()));
        if (!unSeqFileResources.isEmpty()) {
            builder.append("\n").append(String.format(QUERY_ID, queryId)).append(" - UnSeqFiles: ");
            Iterator<TsFileResource> unSeqFileIterator = unSeqFileResources.iterator();
            while (unSeqFileIterator.hasNext()) {
                builder.append(unSeqFileIterator.next().getTsFile().getName());
                if (!unSeqFileIterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        builder.append("\n");
        this.writer.write(builder.toString());
    }

    public void writeChunksInfo(long queryId, long totalChunkNum, long totalChunkPoints) throws IOException {
        double avgChunkPoints = (double)totalChunkPoints / (double)totalChunkNum;
        StringBuilder builder = new StringBuilder(String.format(QUERY_ID, queryId)).append(String.format(" - Number of chunks: %d", totalChunkNum)).append(String.format(", Average data points of chunks: %.1f", avgChunkPoints)).append("\n");
        this.writer.write(builder.toString());
    }

    public void writeOverlappedPageInfo(long queryId, int totalPageNum, int overlappedPageNum) throws IOException {
        StringBuilder builder = new StringBuilder(String.format(QUERY_ID, queryId)).append(" - Rate of overlapped pages: ").append(String.format("%.1f%%, ", (double)overlappedPageNum / (double)totalPageNum * 100.0)).append(String.format("%d overlapped pages in total %d pages.\n", overlappedPageNum, totalPageNum));
        this.writer.write(builder.toString());
    }

    public void writeEndTime(long queryId) throws IOException {
        long endTime = System.currentTimeMillis();
        StringBuilder builder = new StringBuilder(String.format(QUERY_ID, queryId)).append(" - Total cost time: ").append(endTime - this.queryStartTime.remove(queryId)).append("ms\n");
        this.writer.write(builder.toString());
        this.writer.flush();
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            logger.error("Meeting error while Close the tracing log stream : {}", (Object)e.getMessage());
        }
    }

    public boolean getWriterStatus() {
        try {
            this.writer.flush();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void openTracingWriteStream() {
        this.initTracingManager(IoTDBDescriptor.getInstance().getConfig().getTracingDir(), "tracing.txt");
    }

    private static class TracingManagerHelper {
        private static final TracingManager INSTANCE = new TracingManager(IoTDBDescriptor.getInstance().getConfig().getTracingDir(), "tracing.txt");

        private TracingManagerHelper() {
        }
    }
}

