/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.dataset.UDFInputDataSet;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class RawQueryDataSetWithValueFilter
extends QueryDataSet
implements UDFInputDataSet {
    private final TimeGenerator timeGenerator;
    private final List<IReaderByTimestamp> seriesReaderByTimestampList;
    private final List<Boolean> cached;
    private List<RowRecord> cachedRowRecords = new ArrayList<RowRecord>();
    private List<Object[]> cachedRowInObjects = new ArrayList<Object[]>();

    public RawQueryDataSetWithValueFilter(List<PartialPath> paths, List<TSDataType> dataTypes, TimeGenerator timeGenerator, List<IReaderByTimestamp> readers, List<Boolean> cached, boolean ascending) {
        super(new ArrayList<PartialPath>(paths), dataTypes, ascending);
        this.timeGenerator = timeGenerator;
        this.seriesReaderByTimestampList = readers;
        this.cached = cached;
    }

    public boolean hasNextWithoutConstraint() throws IOException {
        if (!this.cachedRowRecords.isEmpty()) {
            return true;
        }
        return this.cacheRowRecords();
    }

    public RowRecord nextWithoutConstraint() throws IOException {
        if (this.cachedRowRecords.isEmpty() && !this.cacheRowRecords()) {
            return null;
        }
        return this.cachedRowRecords.remove(this.cachedRowRecords.size() - 1);
    }

    private boolean cacheRowRecords() throws IOException {
        int i;
        int cachedTimeCnt = 0;
        long[] cachedTimeArray = new long[this.fetchSize];
        while (this.timeGenerator.hasNext() && cachedTimeCnt < this.fetchSize) {
            cachedTimeArray[cachedTimeCnt++] = this.timeGenerator.next();
        }
        if (cachedTimeCnt == 0) {
            return false;
        }
        RowRecord[] rowRecords = new RowRecord[cachedTimeCnt];
        for (int i2 = 0; i2 < cachedTimeCnt; ++i2) {
            rowRecords[i2] = new RowRecord(cachedTimeArray[i2]);
        }
        boolean[] hasField = new boolean[cachedTimeCnt];
        for (i = 0; i < this.seriesReaderByTimestampList.size(); ++i) {
            Object[] results = this.cached.get(i) != false ? this.timeGenerator.getValues((Path)this.paths.get(i)) : this.seriesReaderByTimestampList.get(i).getValuesInTimestamps(cachedTimeArray, cachedTimeCnt);
            for (int j = 0; j < cachedTimeCnt; ++j) {
                if (results[j] == null) {
                    rowRecords[j].addField(null);
                    continue;
                }
                hasField[j] = true;
                rowRecords[j].addField(results[j], (TSDataType)this.dataTypes.get(i));
            }
        }
        for (i = cachedTimeCnt - 1; i >= 0; --i) {
            if (!hasField[i]) continue;
            this.cachedRowRecords.add(rowRecords[i]);
        }
        if (this.cachedRowRecords.isEmpty() && this.timeGenerator.hasNext()) {
            return this.cacheRowRecords();
        }
        return !this.cachedRowRecords.isEmpty();
    }

    @Override
    public boolean hasNextRowInObjects() throws IOException {
        if (!this.cachedRowInObjects.isEmpty()) {
            return true;
        }
        return this.cacheRowInObjects();
    }

    @Override
    public Object[] nextRowInObjects() throws IOException {
        if (this.cachedRowInObjects.isEmpty() && !this.cacheRowInObjects()) {
            return new Object[this.seriesReaderByTimestampList.size() + 1];
        }
        return this.cachedRowInObjects.remove(this.cachedRowInObjects.size() - 1);
    }

    private boolean cacheRowInObjects() throws IOException {
        int i;
        int cachedTimeCnt = 0;
        long[] cachedTimeArray = new long[this.fetchSize];
        while (this.timeGenerator.hasNext() && cachedTimeCnt < this.fetchSize) {
            cachedTimeArray[cachedTimeCnt++] = this.timeGenerator.next();
        }
        if (cachedTimeCnt == 0) {
            return false;
        }
        Object[][] rowsInObject = new Object[cachedTimeCnt][this.seriesReaderByTimestampList.size() + 1];
        for (int i2 = 0; i2 < cachedTimeCnt; ++i2) {
            rowsInObject[i2][this.seriesReaderByTimestampList.size()] = cachedTimeArray[i2];
        }
        boolean[] hasField = new boolean[cachedTimeCnt];
        for (i = 0; i < this.seriesReaderByTimestampList.size(); ++i) {
            Object[] results = this.cached.get(i) != false ? this.timeGenerator.getValues((Path)this.paths.get(i)) : this.seriesReaderByTimestampList.get(i).getValuesInTimestamps(cachedTimeArray, cachedTimeCnt);
            for (int j = 0; j < cachedTimeCnt; ++j) {
                if (results[j] == null) continue;
                hasField[j] = true;
                rowsInObject[j][i] = results[j];
            }
        }
        for (i = cachedTimeCnt - 1; i >= 0; --i) {
            if (!hasField[i]) continue;
            this.cachedRowInObjects.add(rowsInObject[i]);
        }
        if (this.cachedRowInObjects.isEmpty() && this.timeGenerator.hasNext()) {
            return this.cacheRowInObjects();
        }
        return !this.cachedRowInObjects.isEmpty();
    }
}

