/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.NonAlignEngineDataSet;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithValueFilter;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;

public class RawDataQueryExecutor {
    protected RawDataQueryPlan queryPlan;

    public RawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context) throws StorageEngineException, QueryProcessException {
        QueryDataSet dataSet = this.needRedirect(context, false);
        if (dataSet != null) {
            return dataSet;
        }
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context);
        try {
            return new RawQueryDataSetWithoutValueFilter(context.getQueryId(), this.queryPlan.getDeduplicatedPaths(), this.queryPlan.getDeduplicatedDataTypes(), readersOfSelectedSeries, this.queryPlan.isAscending());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageEngineException(e.getMessage());
        }
        catch (IOException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    public final QueryDataSet executeNonAlign(QueryContext context) throws StorageEngineException, QueryProcessException {
        QueryDataSet dataSet = this.needRedirect(context, false);
        if (dataSet != null) {
            return dataSet;
        }
        List<ManagedSeriesReader> readersOfSelectedSeries = this.initManagedSeriesReader(context);
        return new NonAlignEngineDataSet(context.getQueryId(), this.queryPlan.getDeduplicatedPaths(), this.queryPlan.getDeduplicatedDataTypes(), readersOfSelectedSeries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ManagedSeriesReader> initManagedSeriesReader(QueryContext context) throws StorageEngineException, QueryProcessException {
        Filter timeFilter = null;
        if (this.queryPlan.getExpression() != null) {
            timeFilter = ((GlobalTimeExpression)this.queryPlan.getExpression()).getFilter();
        }
        ArrayList<ManagedSeriesReader> readersOfSelectedSeries = new ArrayList<ManagedSeriesReader>();
        List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(this.queryPlan.getDeduplicatedPaths());
        try {
            for (int i = 0; i < this.queryPlan.getDeduplicatedPaths().size(); ++i) {
                PartialPath path = this.queryPlan.getDeduplicatedPaths().get(i);
                TSDataType dataType = this.queryPlan.getDeduplicatedDataTypes().get(i);
                QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, timeFilter);
                timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
                SeriesRawDataBatchReader reader = new SeriesRawDataBatchReader(path, this.queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, queryDataSource, timeFilter, null, null, this.queryPlan.isAscending());
                readersOfSelectedSeries.add(reader);
            }
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(list);
        }
        return readersOfSelectedSeries;
    }

    public final QueryDataSet executeWithValueFilter(QueryContext context) throws StorageEngineException, QueryProcessException {
        QueryDataSet dataSet = this.needRedirect(context, true);
        if (dataSet != null) {
            return dataSet;
        }
        TimeGenerator timestampGenerator = this.getTimeGenerator(context, this.queryPlan);
        List cached = ExecutorWithTimeGenerator.markFilterdPaths((IExpression)this.queryPlan.getExpression(), new ArrayList<PartialPath>(this.queryPlan.getDeduplicatedPaths()), (boolean)timestampGenerator.hasOrNode());
        List<IReaderByTimestamp> readersOfSelectedSeries = this.initSeriesReaderByTimestamp(context, this.queryPlan, cached);
        return new RawQueryDataSetWithValueFilter(this.queryPlan.getDeduplicatedPaths(), this.queryPlan.getDeduplicatedDataTypes(), timestampGenerator, readersOfSelectedSeries, cached, this.queryPlan.isAscending());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IReaderByTimestamp> initSeriesReaderByTimestamp(QueryContext context, RawDataQueryPlan queryPlan, List<Boolean> cached) throws QueryProcessException, StorageEngineException {
        ArrayList<IReaderByTimestamp> readersOfSelectedSeries = new ArrayList<IReaderByTimestamp>();
        List<StorageGroupProcessor> list = StorageEngine.getInstance().mergeLock(queryPlan.getDeduplicatedPaths());
        try {
            for (int i = 0; i < queryPlan.getDeduplicatedPaths().size(); ++i) {
                if (cached.get(i).booleanValue()) {
                    readersOfSelectedSeries.add(null);
                    continue;
                }
                PartialPath path = queryPlan.getDeduplicatedPaths().get(i);
                IReaderByTimestamp seriesReaderByTimestamp = this.getReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), queryPlan.getDeduplicatedDataTypes().get(i), context);
                readersOfSelectedSeries.add(seriesReaderByTimestamp);
            }
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(list);
        }
        return readersOfSelectedSeries;
    }

    protected IReaderByTimestamp getReaderByTimestamp(PartialPath path, Set<String> allSensors, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, allSensors, dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null), null, this.queryPlan.isAscending());
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(context, queryPlan);
    }

    protected QueryDataSet needRedirect(QueryContext context, boolean hasValueFilter) throws StorageEngineException, QueryProcessException {
        return null;
    }
}

