/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.transformer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class Transformer
implements LayerPointReader {
    protected boolean hasCachedValue = false;
    protected long cachedTime;
    protected int cachedInt;
    protected long cachedLong;
    protected float cachedFloat;
    protected double cachedDouble;
    protected boolean cachedBoolean;
    protected Binary cachedBinary;

    protected Transformer() {
    }

    @Override
    public final boolean next() throws QueryProcessException, IOException {
        if (!this.hasCachedValue) {
            this.hasCachedValue = this.cacheValue();
        }
        return this.hasCachedValue;
    }

    protected abstract boolean cacheValue() throws QueryProcessException, IOException;

    @Override
    public final void readyForNext() {
        this.hasCachedValue = false;
    }

    @Override
    public final long currentTime() {
        return this.cachedTime;
    }

    @Override
    public final int currentInt() {
        return this.cachedInt;
    }

    @Override
    public final long currentLong() {
        return this.cachedLong;
    }

    @Override
    public final float currentFloat() {
        return this.cachedFloat;
    }

    @Override
    public final double currentDouble() {
        return this.cachedDouble;
    }

    @Override
    public final boolean currentBoolean() {
        return this.cachedBoolean;
    }

    @Override
    public final Binary currentBinary() {
        return this.cachedBinary;
    }
}

