/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.v2.read.TsFileSequenceReaderForV2;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileRewriteTool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRewriteTool.class);
    protected TsFileSequenceReader reader;
    protected File oldTsFile;
    protected List<Modification> oldModification;
    protected Iterator<Modification> modsIterator;
    protected Map<TsFileIOWriter, ModificationFile> fileModificationMap;
    protected Deletion currentMod;
    protected Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
    protected Decoder valueDecoder;
    protected Map<Long, TsFileIOWriter> partitionWriterMap;
    protected long maxPlanIndex = Long.MIN_VALUE;
    protected long minPlanIndex = Long.MAX_VALUE;

    public TsFileRewriteTool(TsFileResource resourceToBeRewritten) throws IOException {
        this.oldTsFile = resourceToBeRewritten.getTsFile();
        String file = this.oldTsFile.getAbsolutePath();
        this.reader = new TsFileSequenceReader(file);
        this.partitionWriterMap = new HashMap<Long, TsFileIOWriter>();
        if (FSFactoryProducer.getFSFactory().getFile(file + ".mods").exists()) {
            this.oldModification = (List)resourceToBeRewritten.getModFile().getModifications();
            this.modsIterator = this.oldModification.iterator();
            this.fileModificationMap = new HashMap<TsFileIOWriter, ModificationFile>();
        }
    }

    public TsFileRewriteTool(TsFileResource resourceToBeRewritten, boolean needReaderForV2) throws IOException {
        this.oldTsFile = resourceToBeRewritten.getTsFile();
        String file = this.oldTsFile.getAbsolutePath();
        this.reader = needReaderForV2 ? new TsFileSequenceReaderForV2(file) : new TsFileSequenceReader(file);
        this.partitionWriterMap = new HashMap<Long, TsFileIOWriter>();
        if (FSFactoryProducer.getFSFactory().getFile(file + ".mods").exists()) {
            this.oldModification = (List)resourceToBeRewritten.getModFile().getModifications();
            this.modsIterator = this.oldModification.iterator();
            this.fileModificationMap = new HashMap<TsFileIOWriter, ModificationFile>();
        }
    }

    public static void rewriteTsFile(TsFileResource resourceToBeRewritten, List<TsFileResource> rewrittenResources) throws IOException, WriteProcessException {
        try (TsFileRewriteTool rewriteTool = new TsFileRewriteTool(resourceToBeRewritten);){
            rewriteTool.parseAndRewriteFile(rewrittenResources);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void parseAndRewriteFile(List<TsFileResource> rewrittenResources) throws IOException, WriteProcessException {
        if (!this.fileCheck()) {
            return;
        }
        long headerLength = "TsFile".getBytes().length + 1;
        this.reader.position(headerLength);
        String deviceId = null;
        boolean firstChunkInChunkGroup = true;
        try {
            byte marker;
            block10: while ((marker = this.reader.readMarker()) != 2) {
                switch (marker) {
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = this.reader.readChunkGroupHeader();
                        deviceId = chunkGroupHeader.getDeviceID();
                        firstChunkInChunkGroup = true;
                        this.endChunkGroup();
                        continue block10;
                    }
                    case 1: 
                    case 5: {
                        PageHeader pageHeader;
                        ChunkHeader chunkHeader = this.reader.readChunkHeader(marker);
                        MeasurementSchema measurementSchema = new MeasurementSchema(chunkHeader.getMeasurementID(), chunkHeader.getDataType(), chunkHeader.getEncodingType(), chunkHeader.getCompressionType());
                        TSDataType dataType = chunkHeader.getDataType();
                        TSEncoding encoding = chunkHeader.getEncodingType();
                        ArrayList<PageHeader> pageHeadersInChunk = new ArrayList<PageHeader>();
                        ArrayList<ByteBuffer> dataInChunk = new ArrayList<ByteBuffer>();
                        ArrayList<Boolean> needToDecodeInfo = new ArrayList<Boolean>();
                        for (int dataSize = chunkHeader.getDataSize(); dataSize > 0; dataSize -= pageHeader.getSerializedPageSize()) {
                            pageHeader = this.reader.readPageHeader(dataType, chunkHeader.getChunkType() == 1);
                            boolean needToDecode = this.checkIfNeedToDecode(dataType, encoding, pageHeader);
                            needToDecodeInfo.add(needToDecode);
                            ByteBuffer pageData = !needToDecode ? this.reader.readCompressedPage(pageHeader) : this.reader.readPage(pageHeader, chunkHeader.getCompressionType());
                            pageHeadersInChunk.add(pageHeader);
                            dataInChunk.add(pageData);
                        }
                        this.reWriteChunk(deviceId, firstChunkInChunkGroup, measurementSchema, pageHeadersInChunk, dataInChunk, needToDecodeInfo);
                        firstChunkInChunkGroup = false;
                        continue block10;
                    }
                    case 4: {
                        this.reader.readPlanIndex();
                        for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                            long tmpMaxPlanIndex;
                            long tmpMinPlanIndex = this.reader.getMinPlanIndex();
                            if (tmpMinPlanIndex < this.minPlanIndex) {
                                this.minPlanIndex = tmpMinPlanIndex;
                            }
                            if ((tmpMaxPlanIndex = this.reader.getMaxPlanIndex()) < this.maxPlanIndex) {
                                this.maxPlanIndex = tmpMaxPlanIndex;
                            }
                            tsFileIOWriter.setMaxPlanIndex(tmpMinPlanIndex);
                            tsFileIOWriter.setMaxPlanIndex(tmpMaxPlanIndex);
                            tsFileIOWriter.writePlanIndices();
                        }
                        continue block10;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            this.endChunkGroup();
            for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                rewrittenResources.add(this.endFileAndGenerateResource(tsFileIOWriter));
            }
            if (this.oldModification != null) {
                while (this.currentMod != null || this.modsIterator.hasNext()) {
                    if (this.currentMod == null) {
                        this.currentMod = (Deletion)this.modsIterator.next();
                    }
                    for (Map.Entry entry : this.fileModificationMap.entrySet()) {
                        TsFileIOWriter tsFileIOWriter = (TsFileIOWriter)entry.getKey();
                        ModificationFile newMods = (ModificationFile)entry.getValue();
                        newMods.write(new Deletion(this.currentMod.getPath(), tsFileIOWriter.getFile().length(), this.currentMod.getStartTime(), this.currentMod.getEndTime()));
                    }
                    this.currentMod = null;
                }
            }
        }
        catch (IOException e2) {
            throw new IOException("TsFile rewrite process cannot proceed at position " + this.reader.position() + "because: " + e2.getMessage());
        }
        finally {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }

    protected boolean checkIfNeedToDecode(TSDataType dataType, TSEncoding encoding, PageHeader pageHeader) {
        if (pageHeader.getStatistics() == null) {
            return true;
        }
        return StorageEngine.getTimePartition(pageHeader.getStartTime()) != StorageEngine.getTimePartition(pageHeader.getEndTime());
    }

    protected void reWriteChunk(String deviceId, boolean firstChunkInChunkGroup, MeasurementSchema schema, List<PageHeader> pageHeadersInChunk, List<ByteBuffer> pageDataInChunk, List<Boolean> needToDecodeInfoInChunk) throws IOException, PageException {
        this.valueDecoder = Decoder.getDecoderByType((TSEncoding)schema.getEncodingType(), (TSDataType)schema.getType());
        HashMap<Long, ChunkWriterImpl> partitionChunkWriterMap = new HashMap<Long, ChunkWriterImpl>();
        for (int i = 0; i < pageDataInChunk.size(); ++i) {
            if (Boolean.TRUE.equals(needToDecodeInfoInChunk.get(i))) {
                this.decodeAndWritePage(schema, pageDataInChunk.get(i), partitionChunkWriterMap);
                continue;
            }
            this.writePage(schema, pageHeadersInChunk.get(i), pageDataInChunk.get(i), partitionChunkWriterMap);
        }
        for (Map.Entry entry : partitionChunkWriterMap.entrySet()) {
            long partitionId = (Long)entry.getKey();
            TsFileIOWriter tsFileIOWriter = this.partitionWriterMap.get(partitionId);
            if (firstChunkInChunkGroup || !tsFileIOWriter.isWritingChunkGroup()) {
                tsFileIOWriter.startChunkGroup(deviceId);
            }
            IChunkWriter chunkWriter = (IChunkWriter)entry.getValue();
            chunkWriter.writeToFileWriter(tsFileIOWriter);
        }
    }

    protected void endChunkGroup() throws IOException, PageException {
        for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
            tsFileIOWriter.endChunkGroup();
        }
    }

    public String upgradeTsFileName(String oldTsFileName) {
        return oldTsFileName;
    }

    protected TsFileIOWriter getOrDefaultTsFileIOWriter(File oldTsFile, long partition) {
        return this.partitionWriterMap.computeIfAbsent(partition, k -> {
            File partitionDir = FSFactoryProducer.getFSFactory().getFile(oldTsFile.getParent() + File.separator + partition);
            if (!partitionDir.exists()) {
                partitionDir.mkdirs();
            }
            File newFile = FSFactoryProducer.getFSFactory().getFile(partitionDir + File.separator + this.upgradeTsFileName(oldTsFile.getName()));
            try {
                if (newFile.exists()) {
                    logger.debug("delete uncomplated file {}", (Object)newFile);
                    Files.delete(newFile.toPath());
                }
                if (!newFile.createNewFile()) {
                    logger.error("Create new TsFile {} failed because it exists", (Object)newFile);
                }
                TsFileIOWriter writer = new TsFileIOWriter(newFile);
                if (this.oldModification != null) {
                    this.fileModificationMap.put(writer, new ModificationFile(newFile + ".mods"));
                }
                return writer;
            }
            catch (IOException e) {
                logger.error("Create new TsFile {} failed ", (Object)newFile, (Object)e);
                return null;
            }
        });
    }

    protected void writePage(MeasurementSchema schema, PageHeader pageHeader, ByteBuffer pageData, Map<Long, ChunkWriterImpl> partitionChunkWriterMap) throws PageException {
        long partitionId = StorageEngine.getTimePartition(pageHeader.getStartTime());
        this.getOrDefaultTsFileIOWriter(this.oldTsFile, partitionId);
        ChunkWriterImpl chunkWriter = partitionChunkWriterMap.computeIfAbsent(partitionId, v -> new ChunkWriterImpl(schema));
        chunkWriter.writePageHeaderAndDataIntoBuff(pageData, pageHeader);
    }

    protected void decodeAndWritePage(MeasurementSchema schema, ByteBuffer pageData, Map<Long, ChunkWriterImpl> partitionChunkWriterMap) throws IOException {
        this.valueDecoder.reset();
        PageReader pageReader = new PageReader(pageData, schema.getType(), this.valueDecoder, this.defaultTimeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        this.rewritePageIntoFiles(batchData, schema, partitionChunkWriterMap);
    }

    protected void rewritePageIntoFiles(BatchData batchData, MeasurementSchema schema, Map<Long, ChunkWriterImpl> partitionChunkWriterMap) {
        while (batchData.hasCurrent()) {
            long time = batchData.currentTime();
            Object value = batchData.currentValue();
            long partitionId = StorageEngine.getTimePartition(time);
            ChunkWriterImpl chunkWriter = partitionChunkWriterMap.computeIfAbsent(partitionId, v -> new ChunkWriterImpl(schema));
            this.getOrDefaultTsFileIOWriter(this.oldTsFile, partitionId);
            switch (schema.getType()) {
                case INT32: {
                    chunkWriter.write(time, ((Integer)value).intValue());
                    break;
                }
                case INT64: {
                    chunkWriter.write(time, ((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    chunkWriter.write(time, ((Float)value).floatValue());
                    break;
                }
                case DOUBLE: {
                    chunkWriter.write(time, ((Double)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    chunkWriter.write(time, ((Boolean)value).booleanValue());
                    break;
                }
                case TEXT: {
                    chunkWriter.write(time, (Binary)value);
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", schema.getType()));
                }
            }
            batchData.next();
        }
        partitionChunkWriterMap.values().forEach(writer -> writer.sealCurrentPage());
    }

    protected boolean fileCheck() throws IOException {
        String magic = this.reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        byte versionNumber = this.reader.readVersionNumber();
        if (versionNumber != 3) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        if (!this.reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        return true;
    }

    protected TsFileResource endFileAndGenerateResource(TsFileIOWriter tsFileIOWriter) throws IOException {
        tsFileIOWriter.endFile();
        TsFileResource tsFileResource = new TsFileResource(tsFileIOWriter.getFile());
        Map deviceTimeseriesMetadataMap = tsFileIOWriter.getDeviceTimeseriesMetadataMap();
        for (Map.Entry entry : deviceTimeseriesMetadataMap.entrySet()) {
            String device = (String)entry.getKey();
            for (TimeseriesMetadata timeseriesMetaData : (List)entry.getValue()) {
                tsFileResource.updateStartTime(device, timeseriesMetaData.getStatistics().getStartTime());
                tsFileResource.updateEndTime(device, timeseriesMetaData.getStatistics().getEndTime());
            }
        }
        tsFileResource.setMinPlanIndex(this.minPlanIndex);
        tsFileResource.setMaxPlanIndex(this.maxPlanIndex);
        tsFileResource.setClosed(true);
        tsFileResource.serialize();
        return tsFileResource;
    }
}

