/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.PrintStream;
import me.tongfei.progressbar.ConsoleProgressBarConsumer;
import me.tongfei.progressbar.TerminalUtils;

public class InteractiveConsoleProgressBarConsumer
extends ConsoleProgressBarConsumer {
    private boolean initialized = false;
    private int position = 1;

    public InteractiveConsoleProgressBarConsumer(PrintStream out) {
        super(out);
    }

    @Override
    public void accept(String str) {
        if (!this.initialized) {
            TerminalUtils.filterActiveConsumers(InteractiveConsoleProgressBarConsumer.class).forEach(c -> ++c.position);
            TerminalUtils.activeConsumers.add(this);
            this.out.println('\r' + str);
            this.initialized = true;
        } else {
            this.out.print(TerminalUtils.moveCursorUp(this.position) + str + TerminalUtils.moveCursorDown(this.position));
        }
    }

    @Override
    public void close() {
        this.out.flush();
        TerminalUtils.activeConsumers.remove(this);
    }
}

