/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import me.tongfei.progressbar.ProgressBar;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.tool.AbstractCsvTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCsv
extends AbstractCsvTool {
    private static final String FILE_ARGS = "f";
    private static final String FILE_NAME = "file or folder";
    private static final String FILE_SUFFIX = "csv";
    private static final Logger logger = LoggerFactory.getLogger(ImportCsv.class);
    private static final String TIME_TYPE = "It isn't a {} time type";
    private static final String TSFILEDB_CLI_PREFIX = "ImportCsv";
    private static final String ILLEGAL_PATH_ARGUMENT = "Path parameter is null";
    private static int i;
    private static int startIndex;

    private static Options createOptions() {
        Options options = ImportCsv.createNewOptions();
        Option opFile = Option.builder((String)FILE_ARGS).required().argName(FILE_NAME).hasArg().desc("If input a file path, load a csv file, otherwise load all csv file under this directory (required)").build();
        options.addOption(opFile);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDataFromCSV(File file) {
        int fileLine;
        try {
            fileLine = ImportCsv.getFileLineCount(file);
        }
        catch (IOException e) {
            System.out.println("Failed to import file: " + file.getName());
            return;
        }
        System.out.println("Start to import data from: " + file.getName());
        try (BufferedReader br = new BufferedReader(new FileReader(file));
             ProgressBar pb = new ProgressBar("Import from: " + file.getName(), (long)fileLine);){
            String line;
            pb.setExtraMessage("Importing...");
            String header = br.readLine();
            String[] cols = ImportCsv.splitCsvLine(header);
            if (cols.length <= 1) {
                System.out.println("The CSV file " + file.getName() + " illegal, please check first line");
                return;
            }
            ArrayList<String> devices = new ArrayList<String>();
            ArrayList<Long> times = new ArrayList<Long>();
            ArrayList<List> measurementsList = new ArrayList<List>();
            ArrayList valuesList = new ArrayList();
            HashMap<String, List<Integer>> devicesToPositions = new HashMap<String, List<Integer>>();
            HashMap<String, List<String>> devicesToMeasurements = new HashMap<String, List<String>>();
            for (int i = 1; i < cols.length; ++i) {
                ImportCsv.splitColToDeviceAndMeasurement(cols[i], devicesToPositions, devicesToMeasurements, i);
            }
            int lineNumber = 0;
            while ((line = br.readLine()) != null) {
                cols = ImportCsv.splitCsvLine(line);
                ++lineNumber;
                for (Map.Entry deviceToPositions : devicesToPositions.entrySet()) {
                    String device = (String)deviceToPositions.getKey();
                    devices.add(device);
                    times.add(ImportCsv.parseTime(cols[0]));
                    ArrayList<String> values = new ArrayList<String>();
                    Iterator iterator = ((List)deviceToPositions.getValue()).iterator();
                    while (iterator.hasNext()) {
                        int position = (Integer)iterator.next();
                        values.add(cols[position]);
                    }
                    valuesList.add(values);
                    measurementsList.add((List)devicesToMeasurements.get(device));
                }
                if (lineNumber % 10000 != 0) continue;
                session.insertRecords(devices, times, measurementsList, valuesList);
                devices = new ArrayList();
                times = new ArrayList();
                measurementsList = new ArrayList();
                valuesList = new ArrayList();
            }
            session.insertRecords(devices, times, measurementsList, valuesList);
            System.out.println("Insert csv successfully!");
            pb.stepTo((long)fileLine);
        }
        catch (FileNotFoundException e) {
            System.out.println("Cannot find " + file.getName() + " because: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("CSV file read exception because: " + e.getMessage());
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            System.out.println("Meet error when insert csv because " + e.getMessage());
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (IoTDBConnectionException e) {
                System.out.println("Sql statement can not be closed because: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        CommandLine commandLine;
        Options options = ImportCsv.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Parse error: " + e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            return;
        }
        reader.setExpandEvents(false);
        try (ConsoleReader reader = new ConsoleReader();){
            ImportCsv.parseBasicParams(commandLine, reader);
            String filename = commandLine.getOptionValue(FILE_ARGS);
            if (filename == null) {
                hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
                return;
            }
            ImportCsv.parseSpecialParams(commandLine);
            ImportCsv.importCsvFromFile(host, port, username, password, filename, timeZoneID);
        }
    }

    private static long parseTime(String str) {
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat format2 = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        SimpleDateFormat format3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        try {
            return Long.parseLong(str);
        }
        catch (Exception ignored) {
            logger.debug("It isn't a long time type");
            try {
                return format1.parse(str).getTime();
            }
            catch (java.text.ParseException ignored2) {
                logger.debug(TIME_TYPE, (Object)format1.toPattern());
                try {
                    return format2.parse(str).getTime();
                }
                catch (java.text.ParseException ignored3) {
                    logger.debug(TIME_TYPE, (Object)format2.toPattern());
                    try {
                        return format3.parse(str).getTime();
                    }
                    catch (java.text.ParseException ignored4) {
                        logger.debug(TIME_TYPE, (Object)format3.toPattern());
                        throw new IllegalArgumentException("Input time format " + str + "error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or yyyy-MM-ddTHH:mm:ss.SSSZ");
                    }
                }
            }
        }
    }

    private static void parseSpecialParams(CommandLine commandLine) {
        timeZoneID = commandLine.getOptionValue("tz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importCsvFromFile(String ip, String port, String username, String password, String filename, String timeZone) {
        try {
            session = new Session(ip, Integer.parseInt(port), username, password);
            session.open(false);
            timeZoneID = timeZone;
            ImportCsv.setTimeZone();
            File file = new File(filename);
            if (file.isFile()) {
                ImportCsv.importFromSingleFile(file);
            } else if (file.isDirectory()) {
                ImportCsv.importFromDirectory(file);
            }
        }
        catch (IoTDBConnectionException e) {
            System.out.println("Encounter an error when connecting to server, because " + e.getMessage());
        }
        catch (StatementExecutionException e) {
            System.out.println("Encounter an error when executing the statement, because " + e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (IoTDBConnectionException e) {
                    System.out.println("Encounter an error when closing the connection, because " + e.getMessage());
                }
            }
        }
    }

    private static void importFromSingleFile(File file) {
        if (file.getName().endsWith(FILE_SUFFIX)) {
            ImportCsv.loadDataFromCSV(file);
        } else {
            System.out.println("File " + file.getName() + "  should ends with '.csv' if you want to import");
        }
    }

    private static void importFromDirectory(File file) {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File subFile : files) {
            if (!subFile.isFile()) continue;
            if (subFile.getName().endsWith(FILE_SUFFIX)) {
                ImportCsv.loadDataFromCSV(subFile);
                continue;
            }
            System.out.println("File " + file.getName() + " should ends with '.csv' if you want to import");
        }
    }

    private static int getFileLineCount(File file) throws IOException {
        int line;
        try (LineNumberReader count = new LineNumberReader(new FileReader(file));){
            while (count.skip(Long.MAX_VALUE) > 0L) {
            }
            line = count.getLineNumber() + 1;
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void splitColToDeviceAndMeasurement(String col, Map<String, List<Integer>> devicesToPositions, Map<String, List<String>> devicesToMeasurements, int position) {
        if (col.length() > 0) {
            if (col.charAt(col.length() - 1) == '\"') {
                int endIndex = col.lastIndexOf(34, col.length() - 2);
                while (endIndex != -1 && col.charAt(endIndex - 1) == '\\') {
                    endIndex = col.lastIndexOf(34, endIndex - 2);
                }
                if (endIndex == -1 || endIndex != 0 && col.charAt(endIndex - 1) != '.') throw new IllegalArgumentException(ILLEGAL_PATH_ARGUMENT);
                ImportCsv.putDeviceAndMeasurement(col.substring(0, endIndex - 1), col.substring(endIndex), devicesToPositions, devicesToMeasurements, position);
                return;
            } else {
                if (col.charAt(col.length() - 1) == '\"' || col.charAt(col.length() - 1) == '.') throw new IllegalArgumentException(ILLEGAL_PATH_ARGUMENT);
                int endIndex = col.lastIndexOf(46);
                if (endIndex < 0) {
                    ImportCsv.putDeviceAndMeasurement("", col, devicesToPositions, devicesToMeasurements, position);
                    return;
                } else {
                    ImportCsv.putDeviceAndMeasurement(col.substring(0, endIndex), col.substring(endIndex + 1), devicesToPositions, devicesToMeasurements, position);
                }
            }
            return;
        } else {
            ImportCsv.putDeviceAndMeasurement("", col, devicesToPositions, devicesToMeasurements, position);
        }
    }

    private static void putDeviceAndMeasurement(String device, String measurement, Map<String, List<Integer>> devicesToPositions, Map<String, List<String>> devicesToMeasurements, int position) {
        if (devicesToMeasurements.get(device) == null && devicesToPositions.get(device) == null) {
            ArrayList<String> measurements = new ArrayList<String>();
            measurements.add(measurement);
            devicesToMeasurements.put(device, measurements);
            ArrayList<Integer> positions = new ArrayList<Integer>();
            positions.add(position);
            devicesToPositions.put(device, positions);
        } else {
            devicesToMeasurements.get(device).add(measurement);
            devicesToPositions.get(device).add(position);
        }
    }

    public static String[] splitCsvLine(String path) {
        ArrayList<String> nodes = new ArrayList<String>();
        startIndex = 0;
        for (i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == ',') {
                nodes.add(path.substring(startIndex, i));
                startIndex = i + 1;
                continue;
            }
            if (path.charAt(i) == '\"') {
                ImportCsv.nextNode(path, nodes, '\"');
                continue;
            }
            if (path.charAt(i) != '\'') continue;
            ImportCsv.nextNode(path, nodes, '\'');
        }
        if (startIndex <= path.length() - 1) {
            nodes.add(path.substring(startIndex));
        }
        return nodes.toArray(new String[0]);
    }

    public static void nextNode(String path, List<String> nodes, char enclose) {
        int endIndex = path.indexOf(enclose, i + 1);
        while (endIndex != -1 && path.charAt(endIndex - 1) == '\\') {
            endIndex = path.indexOf(enclose, endIndex + 1);
        }
        if (endIndex == -1 || endIndex != path.length() - 1 && path.charAt(endIndex + 1) != ',') {
            throw new IllegalArgumentException("Illegal csv line" + path);
        }
        nodes.add(path.substring(startIndex + 1, endIndex));
        i = endIndex + 1;
        startIndex = endIndex + 2;
    }
}

