/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metrics.ui;

import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.metrics.server.JettyUtil;
import org.apache.iotdb.db.metrics.server.QueryServlet;
import org.apache.iotdb.db.metrics.ui.MetricsPage;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class MetricsWebUI {
    private List<ServletContextHandler> handlers = new ArrayList<ServletContextHandler>();
    private MetricRegistry metricRegistry;

    public MetricsWebUI(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public List<ServletContextHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<ServletContextHandler> handlers) {
        this.handlers = handlers;
    }

    public void initialize() {
        MetricsPage masterPage = new MetricsPage(this.metricRegistry);
        QueryServlet queryServlet = new QueryServlet(masterPage);
        ServletContextHandler staticHandler = JettyUtil.createStaticHandler();
        ServletContextHandler queryHandler = JettyUtil.createServletHandler("/", queryServlet);
        this.handlers.add(staticHandler);
        this.handlers.add(queryHandler);
    }

    public Server getServer(int port) {
        return JettyUtil.getJettyServer(this.handlers, port);
    }
}

