/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mqtt;

import io.moquette.interception.AbstractInterceptHandler;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.mqtt.Message;
import org.apache.iotdb.db.mqtt.PayloadFormatManager;
import org.apache.iotdb.db.mqtt.PayloadFormatter;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishHandler
extends AbstractInterceptHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PublishHandler.class);
    private IPlanExecutor executor;
    private PayloadFormatter payloadFormat;

    public PublishHandler(IoTDBConfig config) {
        this.payloadFormat = PayloadFormatManager.getPayloadFormat(config.getMqttPayloadFormatter());
        try {
            this.executor = new PlanExecutor();
        }
        catch (QueryProcessException e) {
            throw new RuntimeException(e);
        }
    }

    protected PublishHandler(IPlanExecutor executor, PayloadFormatter payloadFormat) {
        this.executor = executor;
        this.payloadFormat = payloadFormat;
    }

    public String getID() {
        return "iotdb-mqtt-broker-listener";
    }

    public void onPublish(InterceptPublishMessage msg) {
        String clientId = msg.getClientID();
        ByteBuf payload = msg.getPayload();
        String topic = msg.getTopicName();
        String username = msg.getUsername();
        MqttQoS qos = msg.getQos();
        LOG.debug("Receive publish message. clientId: {}, username: {}, qos: {}, topic: {}, payload: {}", new Object[]{clientId, username, qos, topic, payload});
        List<Message> events = this.payloadFormat.format(payload);
        if (events == null) {
            return;
        }
        for (Message event : events) {
            if (event == null) continue;
            InsertRowPlan plan = new InsertRowPlan();
            plan.setTime(event.getTimestamp());
            plan.setMeasurements(event.getMeasurements().toArray(new String[event.getMeasurements().size()]));
            plan.setValues(event.getValues().toArray(new Object[event.getValues().size()]));
            plan.setDataTypes(new TSDataType[event.getValues().size()]);
            plan.setNeedInferType(true);
            boolean status = false;
            try {
                plan.setDeviceId(new PartialPath(event.getDevice()));
                status = this.executeNonQuery(plan);
            }
            catch (Exception e) {
                LOG.warn("meet error when inserting device {}, measurements {}, at time {}, because ", new Object[]{event.getDevice(), event.getMeasurements(), event.getTimestamp(), e});
            }
            LOG.debug("event process result: {}", (Object)status);
        }
    }

    private boolean executeNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new QueryProcessException("Current system mode is read-only, does not support non-query operation");
        }
        return this.executor.processNonQuery(plan);
    }
}

