/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.constant;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.metadata.PartialPath;

public class SQLConstant {
    private static final String[] SINGLE_ROOT_ARRAY = new String[1];
    private static final String[] SINGLE_TIME_ARRAY = new String[1];
    public static final PartialPath TIME_PATH = new PartialPath(SINGLE_TIME_ARRAY);
    public static final String ALIGNBY_DEVICE_COLUMN_NAME = "Device";
    public static final String RESERVED_TIME = "time";
    public static final String IS_AGGREGATION = "IS_AGGREGATION";
    public static final String NOW_FUNC = "now()";
    public static final String START_TIME_STR = "1970-1-01T00:00:00";
    public static final String LINE_FEED_SIGNAL = "\n";
    public static final String ROOT = "root";
    public static final String METADATA_PARAM_EQUAL = "=";
    public static final String QUOTE = "'";
    public static final String DQUOTE = "\"";
    public static final String BOOLEAN_TRUE = "true";
    public static final String BOOLEAN_FALSE = "false";
    public static final String BOOLEAN_TRUE_NUM = "1";
    public static final String BOOLEAN_FALSE_NUM = "0";
    public static final String MIN_TIME = "min_time";
    public static final String MAX_TIME = "max_time";
    public static final String MAX_VALUE = "max_value";
    public static final String MIN_VALUE = "min_value";
    public static final String FIRST_VALUE = "first_value";
    public static final String LAST_VALUE = "last_value";
    public static final String LAST = "last";
    public static final String COUNT = "count";
    public static final String AVG = "avg";
    public static final String SUM = "sum";
    public static final String ALL = "all";
    public static final int KW_AND = 1;
    public static final int KW_OR = 2;
    public static final int KW_NOT = 3;
    public static final int EQUAL = 131;
    public static final int NOTEQUAL = 136;
    public static final int LESSTHANOREQUALTO = 135;
    public static final int LESSTHAN = 134;
    public static final int GREATERTHANOREQUALTO = 133;
    public static final int GREATERTHAN = 132;
    public static final int IN = 137;
    public static final int TOK_SELECT = 21;
    public static final int TOK_FROM = 22;
    public static final int TOK_WHERE = 23;
    public static final int TOK_INSERT = 24;
    public static final int TOK_DELETE = 25;
    public static final int TOK_UPDATE = 26;
    public static final int TOK_QUERY = 27;
    public static final int TOK_CREATE_INDEX = 31;
    public static final int TOK_DROP_INDEX = 32;
    public static final int TOK_QUERY_INDEX = 33;
    public static final int TOK_GRANT_WATERMARK_EMBEDDING = 34;
    public static final int TOK_REVOKE_WATERMARK_EMBEDDING = 35;
    public static final int TOK_AUTHOR_CREATE = 41;
    public static final int TOK_AUTHOR_DROP = 42;
    public static final int TOK_AUTHOR_GRANT = 43;
    public static final int TOK_AUTHOR_REVOKE = 44;
    public static final int TOK_AUTHOR_UPDATE_USER = 46;
    public static final int TOK_DATALOAD = 45;
    public static final int TOK_METADATA_CREATE = 51;
    public static final int TOK_METADATA_DELETE = 52;
    public static final int TOK_METADATA_SET_FILE_LEVEL = 53;
    public static final int TOK_PROPERTY_CREATE = 54;
    public static final int TOK_PROPERTY_ADD_LABEL = 55;
    public static final int TOK_PROPERTY_DELETE_LABEL = 56;
    public static final int TOK_PROPERTY_LINK = 57;
    public static final int TOK_PROPERTY_UNLINK = 58;
    public static final int TOK_LIST = 59;
    public static final int TOK_DURATION = 60;
    public static final int TOK_DATE_EXPR = 61;
    public static final int TOK_METADATA_DELETE_FILE_LEVEL = 62;
    public static final int TOK_SET = 63;
    public static final int TOK_UNSET = 64;
    public static final int TOK_SHOW = 65;
    public static final int TOK_LOAD_CONFIGURATION = 66;
    public static final int TOK_FLUSH_TASK_INFO = 67;
    public static final int TOK_LOAD_FILES = 69;
    public static final int TOK_REMOVE_FILE = 70;
    public static final int TOK_MOVE_FILE = 71;
    public static final int TOK_VERSION = 72;
    public static final int TOK_TIMESERIES = 73;
    public static final int TOK_STORAGE_GROUP = 74;
    public static final int TOK_CHILD_PATHS = 75;
    public static final int TOK_DEVICES = 76;
    public static final int TOK_COUNT_TIMESERIES = 77;
    public static final int TOK_COUNT_NODE_TIMESERIES = 78;
    public static final int TOK_COUNT_NODES = 79;
    public static final int TOK_METADATA_ALTER = 80;
    public static final int TOK_FLUSH = 81;
    public static final int TOK_MERGE = 82;
    public static final int TOK_FULL_MERGE = 83;
    public static final int TOK_CLEAR_CACHE = 84;
    public static final int TOK_LOAD_CONFIGURATION_GLOBAL = 85;
    public static final int TOK_LOAD_CONFIGURATION_LOCAL = 86;
    public static final int TOK_SHOW_MERGE_STATUS = 87;
    public static final int TOK_DELETE_PARTITION = 88;
    public static final int TOK_CREATE_SCHEMA_SNAPSHOT = 89;
    public static final int TOK_TRACING = 91;
    public static final int TOK_COUNT_DEVICES = 92;
    public static final int TOK_COUNT_STORAGE_GROUP = 93;
    public static final Map<Integer, String> tokenSymbol = new HashMap<Integer, String>();
    public static final Map<Integer, String> tokenNames = new HashMap<Integer, String>();
    public static final Map<Integer, Integer> reverseWords = new HashMap<Integer, Integer>();

    private SQLConstant() {
    }

    public static String[] getSingleRootArray() {
        return SINGLE_ROOT_ARRAY;
    }

    public static String[] getSingleTimeArray() {
        return SINGLE_TIME_ARRAY;
    }

    public static boolean isReservedPath(PartialPath pathStr) {
        return pathStr.equals(TIME_PATH);
    }

    static {
        SQLConstant.SINGLE_ROOT_ARRAY[0] = ROOT;
        SQLConstant.SINGLE_TIME_ARRAY[0] = RESERVED_TIME;
        tokenSymbol.put(1, "&");
        tokenSymbol.put(2, "|");
        tokenSymbol.put(3, "!");
        tokenSymbol.put(131, METADATA_PARAM_EQUAL);
        tokenSymbol.put(136, "<>");
        tokenSymbol.put(135, "<=");
        tokenSymbol.put(134, "<");
        tokenSymbol.put(133, ">=");
        tokenSymbol.put(132, ">");
        tokenNames.put(1, "and");
        tokenNames.put(2, "or");
        tokenNames.put(3, "not");
        tokenNames.put(131, "equal");
        tokenNames.put(136, "not_equal");
        tokenNames.put(135, "lessthan_or_equalto");
        tokenNames.put(134, "lessthan");
        tokenNames.put(133, "greaterthan_or_equalto");
        tokenNames.put(132, "greaterthan");
        tokenNames.put(137, "in");
        tokenNames.put(21, "TOK_SELECT");
        tokenNames.put(22, "TOK_FROM");
        tokenNames.put(23, "TOK_WHERE");
        tokenNames.put(24, "TOK_INSERT");
        tokenNames.put(25, "TOK_DELETE");
        tokenNames.put(26, "TOK_UPDATE");
        tokenNames.put(27, "TOK_QUERY");
        tokenNames.put(41, "TOK_AUTHOR_CREATE");
        tokenNames.put(42, "TOK_AUTHOR_DROP");
        tokenNames.put(43, "TOK_AUTHOR_GRANT");
        tokenNames.put(44, "TOK_AUTHOR_REVOKE");
        tokenNames.put(46, "TOK_AUTHOR_UPDATE_USER");
        tokenNames.put(45, "TOK_DATALOAD");
        tokenNames.put(51, "TOK_METADATA_CREATE");
        tokenNames.put(52, "TOK_METADATA_DELETE");
        tokenNames.put(53, "TOK_METADATA_SET_FILE_LEVEL");
        tokenNames.put(62, "TOK_METADATA_DELETE_FILE_LEVEL");
        tokenNames.put(54, "TOK_PROPERTY_CREATE");
        tokenNames.put(55, "TOK_PROPERTY_ADD_LABEL");
        tokenNames.put(56, "TOK_PROPERTY_DELETE_LABEL");
        tokenNames.put(57, "TOK_PROPERTY_LINK");
        tokenNames.put(58, "TOK_PROPERTY_UNLINK");
        tokenNames.put(59, "TOK_LIST");
        tokenNames.put(63, "TOK_SET");
        tokenNames.put(64, "TOK_UNSET");
        tokenNames.put(65, "TOK_SHOW");
        tokenNames.put(66, "TOK_LOAD_CONFIGURATION");
        tokenNames.put(67, "TOK_FLUSH_TASK_INFO");
        tokenNames.put(69, "TOK_LOAD_FILES");
        tokenNames.put(70, "TOK_REMOVE_FILE");
        tokenNames.put(71, "TOK_MOVE_FILE");
        tokenNames.put(87, "TOK_SHOW_MERGE_STATUS");
        tokenNames.put(88, "TOK_DELETE_PARTITION");
        tokenNames.put(91, "TOK_TRACING");
        reverseWords.put(1, 2);
        reverseWords.put(2, 1);
        reverseWords.put(131, 136);
        reverseWords.put(136, 131);
        reverseWords.put(134, 133);
        reverseWords.put(133, 134);
        reverseWords.put(135, 132);
        reverseWords.put(132, 135);
    }
}

