/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical;

import org.apache.iotdb.db.qp.constant.SQLConstant;

public abstract class Operator {
    protected int tokenIntType;
    protected String tokenName;
    protected OperatorType operatorType = OperatorType.NULL;

    public Operator(int tokenIntType) {
        this.tokenIntType = tokenIntType;
        this.tokenName = SQLConstant.tokenNames.get(tokenIntType);
    }

    public OperatorType getType() {
        return this.operatorType;
    }

    public boolean isQuery() {
        return this.operatorType == OperatorType.QUERY;
    }

    public int getTokenIntType() {
        return this.tokenIntType;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setOperatorType(OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    public String toString() {
        return this.tokenName;
    }

    public static enum OperatorType {
        SFW,
        JOIN,
        UNION,
        FILTER,
        GROUPBYTIME,
        ORDERBY,
        LIMIT,
        SELECT,
        SEQTABLESCAN,
        HASHTABLESCAN,
        MERGEJOIN,
        FILEREAD,
        NULL,
        TABLESCAN,
        UPDATE,
        INSERT,
        BATCHINSERT,
        DELETE,
        BASIC_FUNC,
        IN,
        QUERY,
        MERGEQUERY,
        AGGREGATION,
        AUTHOR,
        FROM,
        FUNC,
        LOADDATA,
        METADATA,
        INDEX,
        INDEXQUERY,
        FILL,
        SET_STORAGE_GROUP,
        CREATE_TIMESERIES,
        DELETE_TIMESERIES,
        CREATE_USER,
        DELETE_USER,
        MODIFY_PASSWORD,
        GRANT_USER_PRIVILEGE,
        REVOKE_USER_PRIVILEGE,
        GRANT_USER_ROLE,
        REVOKE_USER_ROLE,
        CREATE_ROLE,
        DELETE_ROLE,
        GRANT_ROLE_PRIVILEGE,
        REVOKE_ROLE_PRIVILEGE,
        LIST_USER,
        LIST_ROLE,
        LIST_USER_PRIVILEGE,
        LIST_ROLE_PRIVILEGE,
        LIST_USER_ROLES,
        LIST_ROLE_USERS,
        GRANT_WATERMARK_EMBEDDING,
        REVOKE_WATERMARK_EMBEDDING,
        TTL,
        DELETE_STORAGE_GROUP,
        LOAD_CONFIGURATION,
        SHOW,
        LOAD_FILES,
        REMOVE_FILE,
        MOVE_FILE,
        LAST,
        GROUP_BY_FILL,
        ALTER_TIMESERIES,
        FLUSH,
        MERGE,
        FULL_MERGE,
        CLEAR_CACHE,
        SHOW_MERGE_STATUS,
        CREATE_SCHEMA_SNAPSHOT,
        TRACING,
        DELETE_PARTITION,
        CREATE_MULTI_TIMESERIES,
        BATCH_INSERT_ONE_DEVICE;

    }
}

