/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class QueryPlan
extends PhysicalPlan {
    protected List<PartialPath> paths = null;
    private List<TSDataType> dataTypes = null;
    private boolean alignByTime = true;
    private int rowLimit = 0;
    private int rowOffset = 0;
    private boolean ascending = true;
    private Map<String, Integer> pathToIndex = new HashMap<String, Integer>();

    public QueryPlan() {
        super(true);
        this.setOperatorType(Operator.OperatorType.QUERY);
    }

    public QueryPlan(boolean isQuery, Operator.OperatorType operatorType) {
        super(isQuery, operatorType);
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.paths;
    }

    @Override
    public void setPaths(List<PartialPath> paths) {
        this.paths = paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public boolean hasLimit() {
        return this.rowLimit > 0;
    }

    public boolean isAlignByTime() {
        return this.alignByTime;
    }

    public void setAlignByTime(boolean align) {
        this.alignByTime = align;
    }

    public void addPathToIndex(String columnName, Integer index) {
        this.pathToIndex.put(columnName, index);
    }

    public Map<String, Integer> getPathToIndex() {
        return this.pathToIndex;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

