/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;

public class ShowTimeSeriesPlan
extends ShowPlan {
    private PartialPath path;
    private boolean isContains;
    private String key;
    private String value;
    private int limit = 0;
    private int offset = 0;
    private boolean orderByHeat;
    private boolean hasLimit;

    public ShowTimeSeriesPlan(PartialPath path) {
        super(ShowPlan.ShowContentType.TIMESERIES);
        this.path = path;
    }

    public ShowTimeSeriesPlan(PartialPath path, boolean isContains, String key, String value, int limit, int offset, boolean orderByHeat) {
        super(ShowPlan.ShowContentType.TIMESERIES);
        this.path = path;
        this.isContains = isContains;
        this.key = key;
        this.value = value;
        this.limit = limit;
        this.offset = offset;
        this.orderByHeat = orderByHeat;
    }

    public ShowTimeSeriesPlan() {
        super(ShowPlan.ShowContentType.TIMESERIES);
    }

    public PartialPath getPath() {
        return this.path;
    }

    public boolean isContains() {
        return this.isContains;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isOrderByHeat() {
        return this.orderByHeat;
    }

    public void setOrderByHeat(boolean orderByHeat) {
        this.orderByHeat = orderByHeat;
    }

    public boolean hasLimit() {
        return this.hasLimit;
    }

    public void setHasLimit(boolean hasLimit) {
        this.hasLimit = hasLimit;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        outputStream.write(PhysicalPlan.PhysicalPlanType.SHOW_TIMESERIES.ordinal());
        this.putString(outputStream, this.path.getFullPath());
        outputStream.writeBoolean(this.isContains);
        this.putString(outputStream, this.key);
        this.putString(outputStream, this.value);
        outputStream.writeInt(this.limit);
        outputStream.writeInt(this.offset);
        outputStream.writeBoolean(this.orderByHeat);
        outputStream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.path = new PartialPath(this.readString(buffer));
        this.isContains = buffer.get() == 1;
        this.key = this.readString(buffer);
        this.value = this.readString(buffer);
        this.limit = buffer.getInt();
        this.limit = buffer.getInt();
        this.orderByHeat = buffer.get() == 1;
        this.index = buffer.getLong();
    }
}

