/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;

public class QueryContext {
    private Map<String, Map<String, List<Modification>>> filePathModCache = new ConcurrentHashMap<String, Map<String, List<Modification>>>();
    private Map<String, List<Modification>> fileModCache = new HashMap<String, List<Modification>>();
    private long queryId;
    private long queryTimeLowerBound = Long.MIN_VALUE;

    public QueryContext() {
    }

    public QueryContext(long queryId) {
        this.queryId = queryId;
    }

    public List<Modification> getPathModifications(ModificationFile modFile, PartialPath path) {
        Map fileModifications = this.filePathModCache.computeIfAbsent(modFile.getFilePath(), k -> new ConcurrentHashMap());
        return fileModifications.computeIfAbsent(path.getFullPath(), k -> {
            List allModifications = this.fileModCache.get(modFile.getFilePath());
            if (allModifications == null) {
                allModifications = (List)modFile.getModifications();
                this.fileModCache.put(modFile.getFilePath(), allModifications);
            }
            ArrayList finalPathModifications = new ArrayList();
            if (!allModifications.isEmpty()) {
                allModifications.forEach(modification -> {
                    if (modification.getPath().matchFullPath(path)) {
                        finalPathModifications.add(modification);
                    }
                });
            }
            return finalPathModifications;
        });
    }

    public long getQueryId() {
        return this.queryId;
    }

    public long getQueryTimeLowerBound() {
        return this.queryTimeLowerBound;
    }

    public void setQueryTimeLowerBound(long queryTimeLowerBound) {
        this.queryTimeLowerBound = queryTimeLowerBound;
    }

    public boolean chunkNotSatisfy(ChunkMetadata chunkMetaData) {
        return chunkMetaData.getEndTime() < this.queryTimeLowerBound;
    }
}

