/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByFillDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByTimeDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithoutValueFilterDataSet;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.FillQueryExecutor;
import org.apache.iotdb.db.query.executor.IQueryRouter;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.RawDataQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRouter
implements IQueryRouter {
    private static Logger logger = LoggerFactory.getLogger(QueryRouter.class);

    @Override
    public QueryDataSet rawDataQuery(RawDataQueryPlan queryPlan, QueryContext context) throws StorageEngineException, QueryProcessException {
        IExpression optimizedExpression;
        IExpression expression = queryPlan.getExpression();
        List<PartialPath> deduplicatedPaths = queryPlan.getDeduplicatedPaths();
        try {
            optimizedExpression = expression == null ? null : ExpressionOptimizer.getInstance().optimize(expression, new ArrayList<PartialPath>(deduplicatedPaths));
        }
        catch (QueryFilterOptimizationException e) {
            throw new StorageEngineException(e.getMessage());
        }
        queryPlan.setExpression(optimizedExpression);
        RawDataQueryExecutor rawDataQueryExecutor = this.getRawDataQueryExecutor(queryPlan);
        if (!queryPlan.isAlignByTime()) {
            return rawDataQueryExecutor.executeNonAlign(context);
        }
        if (optimizedExpression != null && optimizedExpression.getType() != ExpressionType.GLOBAL_TIME) {
            return rawDataQueryExecutor.executeWithValueFilter(context);
        }
        return rawDataQueryExecutor.executeWithoutValueFilter(context);
    }

    protected RawDataQueryExecutor getRawDataQueryExecutor(RawDataQueryPlan queryPlan) {
        return new RawDataQueryExecutor(queryPlan);
    }

    @Override
    public QueryDataSet aggregate(AggregationPlan aggregationPlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("paths:" + aggregationPlan.getPaths() + " level:" + aggregationPlan.getLevel() + " duplicatePaths:" + aggregationPlan.getDeduplicatedPaths() + " deduplicatePaths:" + aggregationPlan.getDeduplicatedAggregations());
        }
        IExpression expression = aggregationPlan.getExpression();
        List<PartialPath> deduplicatedPaths = aggregationPlan.getDeduplicatedPaths();
        IExpression optimizedExpression = expression == null ? null : ExpressionOptimizer.getInstance().optimize(expression, new ArrayList<PartialPath>(deduplicatedPaths));
        aggregationPlan.setExpression(optimizedExpression);
        AggregationExecutor engineExecutor = this.getAggregationExecutor(aggregationPlan);
        QueryDataSet dataSet = null;
        dataSet = optimizedExpression != null && optimizedExpression.getType() != ExpressionType.GLOBAL_TIME ? engineExecutor.executeWithValueFilter(context, aggregationPlan) : engineExecutor.executeWithoutValueFilter(context, aggregationPlan);
        return dataSet;
    }

    protected AggregationExecutor getAggregationExecutor(AggregationPlan aggregationPlan) {
        return new AggregationExecutor(aggregationPlan);
    }

    @Override
    public QueryDataSet groupBy(GroupByTimePlan groupByTimePlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("paths:" + groupByTimePlan.getPaths() + " level:" + groupByTimePlan.getLevel());
        }
        GroupByEngineDataSet dataSet = null;
        long unit = groupByTimePlan.getInterval();
        long slidingStep = groupByTimePlan.getSlidingStep();
        long startTime = groupByTimePlan.getStartTime();
        long endTime = groupByTimePlan.getEndTime();
        Object expression = groupByTimePlan.getExpression();
        List<PartialPath> selectedSeries = groupByTimePlan.getDeduplicatedPaths();
        GlobalTimeExpression timeExpression = new GlobalTimeExpression((Filter)new GroupByFilter(unit, slidingStep, startTime, endTime));
        expression = expression == null ? timeExpression : BinaryExpression.and((IExpression)expression, (IExpression)timeExpression);
        IExpression optimizedExpression = ExpressionOptimizer.getInstance().optimize(expression, new ArrayList<PartialPath>(selectedSeries));
        groupByTimePlan.setExpression(optimizedExpression);
        dataSet = optimizedExpression.getType() == ExpressionType.GLOBAL_TIME ? this.getGroupByWithoutValueFilterDataSet(context, groupByTimePlan) : this.getGroupByWithValueFilterDataSet(context, groupByTimePlan);
        if (groupByTimePlan.getLevel() >= 0) {
            return this.groupByLevelWithoutTimeIntervalDataSet(context, groupByTimePlan, dataSet);
        }
        return dataSet;
    }

    protected GroupByWithoutValueFilterDataSet getGroupByWithoutValueFilterDataSet(QueryContext context, GroupByTimePlan plan) throws StorageEngineException, QueryProcessException {
        return new GroupByWithoutValueFilterDataSet(context, plan);
    }

    protected GroupByWithValueFilterDataSet getGroupByWithValueFilterDataSet(QueryContext context, GroupByTimePlan plan) throws StorageEngineException, QueryProcessException {
        return new GroupByWithValueFilterDataSet(context, plan);
    }

    protected GroupByTimeDataSet groupByLevelWithoutTimeIntervalDataSet(QueryContext context, GroupByTimePlan plan, GroupByEngineDataSet dataSet) throws QueryProcessException, IOException {
        return new GroupByTimeDataSet(context, plan, dataSet);
    }

    @Override
    public QueryDataSet fill(FillQueryPlan fillQueryPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        List<PartialPath> fillPaths = fillQueryPlan.getDeduplicatedPaths();
        List<TSDataType> dataTypes = fillQueryPlan.getDeduplicatedDataTypes();
        long queryTime = fillQueryPlan.getQueryTime();
        Map<TSDataType, IFill> fillType = fillQueryPlan.getFillType();
        FillQueryExecutor fillQueryExecutor = this.getFillExecutor(fillPaths, dataTypes, queryTime, fillType);
        return fillQueryExecutor.execute(context, fillQueryPlan);
    }

    protected FillQueryExecutor getFillExecutor(List<PartialPath> fillPaths, List<TSDataType> dataTypes, long queryTime, Map<TSDataType, IFill> fillType) {
        return new FillQueryExecutor(fillPaths, dataTypes, queryTime, fillType);
    }

    @Override
    public QueryDataSet groupByFill(GroupByTimeFillPlan groupByFillPlan, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        GroupByEngineDataSet groupByEngineDataSet = (GroupByEngineDataSet)this.groupBy(groupByFillPlan, context);
        return new GroupByFillDataSet(groupByFillPlan.getDeduplicatedPaths(), groupByFillPlan.getDeduplicatedDataTypes(), groupByEngineDataSet, groupByFillPlan.getFillType(), context, groupByFillPlan);
    }

    @Override
    public QueryDataSet lastQuery(LastQueryPlan lastQueryPlan, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        LastQueryExecutor lastQueryExecutor = new LastQueryExecutor(lastQueryPlan);
        return lastQueryExecutor.execute(context, lastQueryPlan);
    }
}

