/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class MemPageReader
implements IPageReader {
    private final IPointReader timeValuePairIterator;
    private final ChunkMetadata chunkMetadata;
    private Filter valueFilter;

    public MemPageReader(IPointReader timeValuePairIterator, ChunkMetadata chunkMetadata, Filter filter) {
        this.timeValuePairIterator = timeValuePairIterator;
        this.chunkMetadata = chunkMetadata;
        this.valueFilter = filter;
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)this.chunkMetadata.getDataType(), (boolean)ascending, (boolean)false);
        while (this.timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            if (this.valueFilter != null && !this.valueFilter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
            batchData.putAnObject(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue());
        }
        return batchData.flip();
    }

    public Statistics getStatistics() {
        return this.chunkMetadata.getStatistics();
    }

    public void setFilter(Filter filter) {
        this.valueFilter = filter;
    }

    public boolean isModified() {
        return false;
    }
}

