/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.rescon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private long totalSgMemCost = 0L;
    private volatile boolean rejected = false;
    private Map<StorageGroupInfo, Long> reportedSgMemCostMap = new HashMap<StorageGroupInfo, Long>();
    private static final double FLUSH_THERSHOLD = (double)config.getAllocateMemoryForWrite() * config.getFlushProportion();
    private static final double REJECT_THERSHOLD = (double)config.getAllocateMemoryForWrite() * config.getRejectProportion();

    public synchronized void reportStorageGroupStatus(StorageGroupInfo storageGroupInfo) {
        long delta = storageGroupInfo.getMemCost() - this.reportedSgMemCostMap.getOrDefault(storageGroupInfo, 0L);
        this.totalSgMemCost += delta;
        if (logger.isDebugEnabled()) {
            logger.debug("Report Storage Group Status to the system. After adding {}, current sg mem cost is {}.", (Object)delta, (Object)this.totalSgMemCost);
        }
        this.reportedSgMemCostMap.put(storageGroupInfo, storageGroupInfo.getMemCost());
        storageGroupInfo.setLastReportedSize(storageGroupInfo.getMemCost());
        if ((double)this.totalSgMemCost >= FLUSH_THERSHOLD) {
            logger.debug("The total storage group mem costs are too large, call for flushing. Current sg cost is {}", (Object)this.totalSgMemCost);
            this.chooseTSPToMarkFlush();
        }
        if ((double)this.totalSgMemCost >= REJECT_THERSHOLD) {
            logger.info("Change system to reject status...");
            this.rejected = true;
        }
    }

    public synchronized void resetStorageGroupStatus(StorageGroupInfo storageGroupInfo, boolean shouldInvokeFlush) {
        if (this.reportedSgMemCostMap.containsKey(storageGroupInfo)) {
            this.totalSgMemCost -= this.reportedSgMemCostMap.get(storageGroupInfo) - storageGroupInfo.getMemCost();
            storageGroupInfo.setLastReportedSize(storageGroupInfo.getMemCost());
            this.reportedSgMemCostMap.put(storageGroupInfo, storageGroupInfo.getMemCost());
            if (shouldInvokeFlush) {
                this.checkSystemToInvokeFlush();
            }
        }
    }

    private void checkSystemToInvokeFlush() {
        if ((double)this.totalSgMemCost >= FLUSH_THERSHOLD && (double)this.totalSgMemCost < REJECT_THERSHOLD) {
            logger.debug("Some sg memory released but still exceeding flush proportion, call flush.");
            if (this.rejected) {
                logger.info("Some sg memory released, set system to normal status.");
            }
            this.logCurrentTotalSGMemory();
            this.rejected = false;
            this.forceAsyncFlush();
        } else if ((double)this.totalSgMemCost >= REJECT_THERSHOLD) {
            logger.warn("Some sg memory released, but system is still in reject status.");
            this.logCurrentTotalSGMemory();
            this.rejected = true;
            this.forceAsyncFlush();
        } else {
            logger.debug("Some sg memory released, system is in normal status.");
            this.logCurrentTotalSGMemory();
            this.rejected = false;
        }
    }

    private void logCurrentTotalSGMemory() {
        logger.debug("Current Sg cost is {}", (Object)this.totalSgMemCost);
    }

    private void chooseTSPToMarkFlush() {
        if (FlushManager.getInstance().getNumberOfWorkingTasks() > 0) {
            return;
        }
        if (this.reportedSgMemCostMap.size() == 0) {
            return;
        }
        List<TsFileProcessor> processors = this.getTsFileProcessorsToFlush();
        for (TsFileProcessor processor : processors) {
            if (processor == null) continue;
            processor.setFlush();
        }
    }

    private void forceAsyncFlush() {
        if (FlushManager.getInstance().getNumberOfWorkingTasks() > 0) {
            return;
        }
        List<TsFileProcessor> processors = this.getTsFileProcessorsToFlush();
        if (logger.isDebugEnabled()) {
            logger.debug("[mem control] get {} tsp to flush", (Object)processors.size());
        }
        for (TsFileProcessor processor : processors) {
            if (processor == null) continue;
            processor.startAsyncFlush();
        }
    }

    private List<TsFileProcessor> getTsFileProcessorsToFlush() {
        PriorityQueue<TsFileProcessor> tsps = new PriorityQueue<TsFileProcessor>((o1, o2) -> Long.compare(o2.getWorkMemTableRamCost(), o1.getWorkMemTableRamCost()));
        for (StorageGroupInfo sgInfo : this.reportedSgMemCostMap.keySet()) {
            tsps.addAll(sgInfo.getAllReportedTsp());
        }
        ArrayList<TsFileProcessor> processors = new ArrayList<TsFileProcessor>();
        long memCost = 0L;
        while ((double)(this.totalSgMemCost - memCost) > FLUSH_THERSHOLD / 2.0) {
            if (tsps.isEmpty() || ((TsFileProcessor)tsps.peek()).getWorkMemTableRamCost() == 0L) {
                return processors;
            }
            processors.add((TsFileProcessor)tsps.peek());
            memCost += ((TsFileProcessor)tsps.peek()).getWorkMemTableRamCost();
            tsps.poll();
        }
        return processors;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void close() {
        this.reportedSgMemCostMap.clear();
        this.totalSgMemCost = 0L;
        this.rejected = false;
    }

    public static SystemInfo getInstance() {
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static SystemInfo instance = new SystemInfo();

        private InstanceHolder() {
        }
    }
}

