/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

public enum ServiceType {
    STORAGE_ENGINE_SERVICE("Storage Engine ServerService", ""),
    JMX_SERVICE("JMX ServerService", "JMX ServerService"),
    METRICS_SERVICE("Metrics ServerService", "MetricsService"),
    RPC_SERVICE("RPC ServerService", "RPCService"),
    MQTT_SERVICE("MQTTService", ""),
    MONITOR_SERVICE("Monitor ServerService", "Monitor"),
    STAT_MONITOR_SERVICE("Statistics ServerService", ""),
    WAL_SERVICE("WAL ServerService", ""),
    CLOSE_MERGE_SERVICE("Close&Merge ServerService", ""),
    JVM_MEM_CONTROL_SERVICE("Memory Controller", ""),
    AUTHORIZATION_SERVICE("Authorization ServerService", ""),
    FILE_READER_MANAGER_SERVICE("File reader manager ServerService", ""),
    SYNC_SERVICE("SYNC ServerService", ""),
    UPGRADE_SERVICE("UPGRADE DataService", ""),
    MERGE_SERVICE("Merge Manager", "Merge Manager"),
    COMPACTION_SERVICE("Compaction Manager", "Compaction Manager"),
    PERFORMANCE_STATISTIC_SERVICE("PERFORMANCE_STATISTIC_SERVICE", "PERFORMANCE_STATISTIC_SERVICE"),
    TVLIST_ALLOCATOR_SERVICE("TVList Allocator", ""),
    CACHE_HIT_RATIO_DISPLAY_SERVICE("CACHE_HIT_RATIO_DISPLAY_SERVICE", ServiceType.generateJmxName("org.apache.iotdb.service", "Cache Hit Ratio")),
    FLUSH_SERVICE("Flush ServerService", ServiceType.generateJmxName("org.apache.iotdb.db.engine.pool", "Flush Manager")),
    CLUSTER_MONITOR_SERVICE("Cluster Monitor ServerService", "Cluster Monitor");

    private String name;
    private String jmxName;

    private ServiceType(String name, String jmxName) {
        this.name = name;
        this.jmxName = jmxName;
    }

    public String getName() {
        return this.name;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    private static String generateJmxName(String packageName, String jmxName) {
        return String.format("%s:type=%s", packageName, jmxName);
    }
}

