/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.manager;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.writelog.manager.WriteLogNodeManager;
import org.apache.iotdb.db.writelog.node.ExclusiveWriteLogNode;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileLogNodeManager
implements WriteLogNodeManager,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MultiFileLogNodeManager.class);
    private Map<String, WriteLogNode> nodeMap;
    private ScheduledExecutorService executorService;
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    private final void forceTask() {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            logger.warn("system mode is read-only, the force flush WAL task is stopped");
            return;
        }
        if (Thread.interrupted()) {
            logger.info("WAL force thread exits.");
            return;
        }
        for (WriteLogNode node : this.nodeMap.values()) {
            try {
                node.forceSync();
            }
            catch (IOException e) {
                logger.error("Cannot force {}, because ", (Object)node, (Object)e);
            }
        }
    }

    private MultiFileLogNodeManager() {
        this.nodeMap = new ConcurrentHashMap<String, WriteLogNode>();
    }

    public static MultiFileLogNodeManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public WriteLogNode getNode(String identifier) {
        WriteLogNode oldNode;
        WriteLogNode node = this.nodeMap.get(identifier);
        if (node == null && (oldNode = this.nodeMap.putIfAbsent(identifier, node = new ExclusiveWriteLogNode(identifier))) != null) {
            return oldNode;
        }
        return node;
    }

    @Override
    public void deleteNode(String identifier) throws IOException {
        WriteLogNode node = this.nodeMap.remove(identifier);
        if (node != null) {
            node.delete();
        }
    }

    @Override
    public void close() {
        logger.info("{} nodes to be closed", (Object)this.nodeMap.size());
        for (WriteLogNode node : this.nodeMap.values()) {
            try {
                node.close();
            }
            catch (IOException e) {
                logger.error("failed to close {}", (Object)node, (Object)e);
            }
        }
        this.nodeMap.clear();
        logger.info("LogNodeManager closed.");
    }

    @Override
    public void start() throws StartupException {
        try {
            if (!this.config.isEnableWal()) {
                return;
            }
            if (this.config.getForceWalPeriodInMs() > 0L) {
                this.executorService = Executors.newSingleThreadScheduledExecutor();
                this.executorService.scheduleWithFixedDelay(this::forceTask, this.config.getForceWalPeriodInMs(), this.config.getForceWalPeriodInMs(), TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        if (!this.config.isEnableWal()) {
            return;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("force flush wal thread still doesn't exit after 30s");
                Thread.currentThread().interrupt();
            }
        }
        this.close();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.WAL_SERVICE;
    }

    private static class InstanceHolder {
        private static MultiFileLogNodeManager instance = new MultiFileLogNodeManager();

        private InstanceHolder() {
        }
    }
}

