/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexNode;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsFileMetadata {
    private int totalChunkNum;
    private int invalidChunkNum;
    private BloomFilter bloomFilter;
    private MetadataIndexNode metadataIndex;
    private List<Pair<Long, Long>> versionInfo;
    private long metaOffset;

    public static TsFileMetadata deserializeFrom(ByteBuffer buffer) {
        TsFileMetadata fileMetaData = new TsFileMetadata();
        fileMetaData.metadataIndex = MetadataIndexNode.deserializeFrom(buffer);
        fileMetaData.totalChunkNum = ReadWriteIOUtils.readInt(buffer);
        fileMetaData.invalidChunkNum = ReadWriteIOUtils.readInt(buffer);
        ArrayList<Pair<Long, Long>> versionInfo = new ArrayList<Pair<Long, Long>>();
        int versionSize = ReadWriteIOUtils.readInt(buffer);
        for (int i = 0; i < versionSize; ++i) {
            long versionPos = ReadWriteIOUtils.readLong(buffer);
            long version = ReadWriteIOUtils.readLong(buffer);
            versionInfo.add(new Pair<Long, Long>(versionPos, version));
        }
        fileMetaData.setVersionInfo(versionInfo);
        long metaOffset = ReadWriteIOUtils.readLong(buffer);
        fileMetaData.setMetaOffset(metaOffset);
        if (buffer.hasRemaining()) {
            byte[] bytes = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer).array();
            int filterSize = ReadWriteIOUtils.readInt(buffer);
            int hashFunctionSize = ReadWriteIOUtils.readInt(buffer);
            fileMetaData.bloomFilter = BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize);
        }
        return fileMetaData;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen = this.metadataIndex != null ? (byteLen += this.metadataIndex.serializeTo(outputStream)) : (byteLen += ReadWriteIOUtils.write(0, outputStream));
        byteLen += ReadWriteIOUtils.write(this.totalChunkNum, outputStream);
        byteLen += ReadWriteIOUtils.write(this.invalidChunkNum, outputStream);
        byteLen += ReadWriteIOUtils.write(this.versionInfo.size(), outputStream);
        for (Pair<Long, Long> versionPair : this.versionInfo) {
            byteLen += ReadWriteIOUtils.write((long)((Long)versionPair.left), outputStream);
            byteLen += ReadWriteIOUtils.write((long)((Long)versionPair.right), outputStream);
        }
        return byteLen += ReadWriteIOUtils.write(this.metaOffset, outputStream);
    }

    public int serializeBloomFilter(OutputStream outputStream, Set<Path> paths) throws IOException {
        int byteLen = 0;
        BloomFilter filter = this.buildBloomFilter(paths);
        byte[] bytes = filter.serialize();
        byteLen += ReadWriteIOUtils.write(bytes.length, outputStream);
        outputStream.write(bytes);
        byteLen += bytes.length;
        byteLen += ReadWriteIOUtils.write(filter.getSize(), outputStream);
        return byteLen += ReadWriteIOUtils.write(filter.getHashFunctionSize(), outputStream);
    }

    private BloomFilter buildBloomFilter(Set<Path> paths) {
        BloomFilter filter = BloomFilter.getEmptyBloomFilter(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate(), paths.size());
        for (Path path : paths) {
            filter.add(path.toString());
        }
        return filter;
    }

    public int getTotalChunkNum() {
        return this.totalChunkNum;
    }

    public void setTotalChunkNum(int totalChunkNum) {
        this.totalChunkNum = totalChunkNum;
    }

    public int getInvalidChunkNum() {
        return this.invalidChunkNum;
    }

    public void setInvalidChunkNum(int invalidChunkNum) {
        this.invalidChunkNum = invalidChunkNum;
    }

    public long getMetaOffset() {
        return this.metaOffset;
    }

    public void setMetaOffset(long metaOffset) {
        this.metaOffset = metaOffset;
    }

    public MetadataIndexNode getMetadataIndex() {
        return this.metadataIndex;
    }

    public void setMetadataIndex(MetadataIndexNode metadataIndex) {
        this.metadataIndex = metadataIndex;
    }

    public void setVersionInfo(List<Pair<Long, Long>> versionInfo) {
        this.versionInfo = versionInfo;
    }

    public List<Pair<Long, Long>> getVersionInfo() {
        return this.versionInfo;
    }
}

