/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;

public enum TSDataType {
    BOOLEAN,
    INT32,
    INT64,
    FLOAT,
    DOUBLE,
    TEXT;


    public static TSDataType deserialize(short type) {
        return TSDataType.getTsDataType(type);
    }

    private static TSDataType getTsDataType(short type) {
        if (type >= 6 || type < 0) {
            throw new IllegalArgumentException("Invalid input: " + type);
        }
        switch (type) {
            case 0: {
                return BOOLEAN;
            }
            case 1: {
                return INT32;
            }
            case 2: {
                return INT64;
            }
            case 3: {
                return FLOAT;
            }
            case 4: {
                return DOUBLE;
            }
        }
        return TEXT;
    }

    public static byte deserializeToByte(short type) {
        if (type >= 6 || type < 0) {
            throw new IllegalArgumentException("Invalid input: " + type);
        }
        return (byte)type;
    }

    public static TSDataType byteToEnum(byte type) {
        return TSDataType.getTsDataType(type);
    }

    public static TSDataType deserializeFrom(ByteBuffer buffer) {
        return TSDataType.deserialize(buffer.getShort());
    }

    public static int getSerializedSize() {
        return 2;
    }

    public void serializeTo(ByteBuffer byteBuffer) {
        byteBuffer.putShort(this.serialize());
    }

    public void serializeTo(DataOutputStream outputStream) throws IOException {
        outputStream.writeShort(this.serialize());
    }

    public short serialize() {
        return this.enumToByte();
    }

    public int getDataTypeSize() {
        switch (this) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: 
            case FLOAT: {
                return 4;
            }
            case TEXT: 
            case INT64: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new UnSupportedDataTypeException(this.toString());
    }

    public byte enumToByte() {
        switch (this) {
            case BOOLEAN: {
                return 0;
            }
            case INT32: {
                return 1;
            }
            case INT64: {
                return 2;
            }
            case FLOAT: {
                return 3;
            }
            case DOUBLE: {
                return 4;
            }
            case TEXT: {
                return 5;
            }
        }
        return -1;
    }
}

