/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

public enum TSEncoding {
    PLAIN,
    PLAIN_DICTIONARY,
    RLE,
    DIFF,
    TS_2DIFF,
    BITMAP,
    GORILLA_V1,
    REGULAR,
    GORILLA;


    public static TSEncoding deserialize(short encoding) {
        return TSEncoding.getTsEncoding(encoding);
    }

    public static byte deserializeToByte(short encoding) {
        if (encoding < 0 || 8 < encoding) {
            throw new IllegalArgumentException("Invalid input: " + encoding);
        }
        return (byte)encoding;
    }

    private static TSEncoding getTsEncoding(short encoding) {
        if (encoding < 0 || 8 < encoding) {
            throw new IllegalArgumentException("Invalid input: " + encoding);
        }
        switch (encoding) {
            case 1: {
                return PLAIN_DICTIONARY;
            }
            case 2: {
                return RLE;
            }
            case 3: {
                return DIFF;
            }
            case 4: {
                return TS_2DIFF;
            }
            case 5: {
                return BITMAP;
            }
            case 6: {
                return GORILLA_V1;
            }
            case 7: {
                return REGULAR;
            }
            case 8: {
                return GORILLA;
            }
        }
        return PLAIN;
    }

    public static TSEncoding byteToEnum(byte encoding) {
        return TSEncoding.getTsEncoding(encoding);
    }

    public static int getSerializedSize() {
        return 2;
    }

    public short serialize() {
        return this.enumToByte();
    }

    public byte enumToByte() {
        switch (this) {
            case PLAIN_DICTIONARY: {
                return 1;
            }
            case RLE: {
                return 2;
            }
            case DIFF: {
                return 3;
            }
            case TS_2DIFF: {
                return 4;
            }
            case BITMAP: {
                return 5;
            }
            case GORILLA_V1: {
                return 6;
            }
            case REGULAR: {
                return 7;
            }
            case GORILLA: {
                return 8;
            }
        }
        return 0;
    }
}

