/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.AndNode;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.LeafNode;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.OrNode;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;

public abstract class TimeGenerator {
    private HashMap<Path, List<LeafNode>> leafCache = new HashMap();
    protected Node operatorNode;
    private boolean hasOrNode;

    public boolean hasNext() throws IOException {
        return this.operatorNode.hasNext();
    }

    public long next() throws IOException {
        return this.operatorNode.next();
    }

    public Object getValue(Path path, long time) {
        for (LeafNode leafNode : this.leafCache.get(path)) {
            if (!leafNode.currentTimeIs(time)) continue;
            return leafNode.currentValue();
        }
        return null;
    }

    public void constructNode(IExpression expression) throws IOException {
        this.operatorNode = this.construct(expression);
    }

    protected Node construct(IExpression expression) throws IOException {
        if (expression.getType() == ExpressionType.SERIES) {
            SingleSeriesExpression singleSeriesExp = (SingleSeriesExpression)expression;
            IBatchReader seriesReader = this.generateNewBatchReader(singleSeriesExp);
            Path path = singleSeriesExp.getSeriesPath();
            if (!this.leafCache.containsKey(path)) {
                this.leafCache.put(path, new ArrayList());
            }
            LeafNode leafNode = new LeafNode(seriesReader);
            this.leafCache.get(path).add(leafNode);
            return leafNode;
        }
        Node leftChild = this.construct(((IBinaryExpression)expression).getLeft());
        Node rightChild = this.construct(((IBinaryExpression)expression).getRight());
        if (expression.getType() == ExpressionType.OR) {
            this.hasOrNode = true;
            return new OrNode(leftChild, rightChild, this.isAscending());
        }
        if (expression.getType() == ExpressionType.AND) {
            return new AndNode(leftChild, rightChild, this.isAscending());
        }
        throw new UnSupportedDataTypeException("Unsupported ExpressionType when construct OperatorNode: " + (Object)((Object)expression.getType()));
    }

    protected abstract IBatchReader generateNewBatchReader(SingleSeriesExpression var1) throws IOException;

    public boolean hasOrNode() {
        return this.hasOrNode;
    }

    protected abstract boolean isAscending();
}

