/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.file.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.StatisticsV1;

public class HeaderUtils {
    private HeaderUtils() {
    }

    public static PageHeader deserializePageHeaderV1(InputStream inputStream, TSDataType dataType) throws IOException {
        int uncompressedSize = ReadWriteIOUtils.readInt(inputStream);
        int compressedSize = ReadWriteIOUtils.readInt(inputStream);
        int numOfValues = ReadWriteIOUtils.readInt(inputStream);
        long maxTimestamp = ReadWriteIOUtils.readLong(inputStream);
        long minTimestamp = ReadWriteIOUtils.readLong(inputStream);
        StatisticsV1 oldstatistics = StatisticsV1.deserialize(inputStream, dataType);
        Statistics statistics = StatisticsV1.upgradeOldStatistics(oldstatistics, dataType, numOfValues, maxTimestamp, minTimestamp);
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }

    public static PageHeader deserializePageHeaderV1(ByteBuffer buffer, TSDataType dataType) throws IOException {
        int uncompressedSize = ReadWriteIOUtils.readInt(buffer);
        int compressedSize = ReadWriteIOUtils.readInt(buffer);
        int numOfValues = ReadWriteIOUtils.readInt(buffer);
        long maxTimestamp = ReadWriteIOUtils.readLong(buffer);
        long minTimestamp = ReadWriteIOUtils.readLong(buffer);
        StatisticsV1 oldstatistics = StatisticsV1.deserialize(buffer, dataType);
        Statistics statistics = StatisticsV1.upgradeOldStatistics(oldstatistics, dataType, numOfValues, maxTimestamp, minTimestamp);
        return new PageHeader(uncompressedSize, compressedSize, statistics);
    }

    public static ChunkHeader deserializeChunkHeaderV1(InputStream inputStream, boolean markerRead) throws IOException {
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 1) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        String measurementID = ReadWriteIOUtils.readString(inputStream);
        int dataSize = ReadWriteIOUtils.readInt(inputStream);
        TSDataType dataType = TSDataType.deserialize(ReadWriteIOUtils.readShort(inputStream));
        int numOfPages = ReadWriteIOUtils.readInt(inputStream);
        CompressionType type = ReadWriteIOUtils.readCompressionType(inputStream);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding(inputStream);
        ReadWriteIOUtils.readLong(inputStream);
        return new ChunkHeader(measurementID, dataSize, dataType, type, encoding, numOfPages);
    }

    public static ChunkHeader deserializeChunkHeaderV1(TsFileInput input, long offset, int chunkHeaderSize, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        ByteBuffer buffer = ByteBuffer.allocate(chunkHeaderSize);
        input.read(buffer, offsetVar);
        buffer.flip();
        int size = buffer.getInt();
        String measurementID = ReadWriteIOUtils.readStringWithLength(buffer, size);
        int dataSize = ReadWriteIOUtils.readInt(buffer);
        TSDataType dataType = TSDataType.deserialize(ReadWriteIOUtils.readShort(buffer));
        int numOfPages = ReadWriteIOUtils.readInt(buffer);
        CompressionType type = ReadWriteIOUtils.readCompressionType(buffer);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding(buffer);
        ReadWriteIOUtils.readLong(buffer);
        return new ChunkHeader(measurementID, dataSize, dataType, type, encoding, numOfPages);
    }

    public static int getSerializedSizeV1(String measurementID) {
        return 5 + measurementID.getBytes(TSFileConfig.STRING_CHARSET).length + 4 + TSDataType.getSerializedSize() + CompressionType.getSerializedSize() + TSEncoding.getSerializedSize() + 4 + 8;
    }
}

