/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;

public class LocalTsFileOutput
implements TsFileOutput {
    private FileOutputStream outputStream;
    private BufferedOutputStream bufferedStream;

    LocalTsFileOutput(File file, boolean append) throws FileNotFoundException {
        this.outputStream = new FileOutputStream(file, append);
        this.bufferedStream = new BufferedOutputStream(this.outputStream);
    }

    public LocalTsFileOutput(FileOutputStream outputStream) {
        this.outputStream = outputStream;
        this.bufferedStream = new BufferedOutputStream(outputStream);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.bufferedStream.write(b);
    }

    @Override
    public void write(ByteBuffer b) throws IOException {
        this.bufferedStream.write(b.array());
    }

    @Override
    public long getPosition() throws IOException {
        this.bufferedStream.flush();
        return this.outputStream.getChannel().position();
    }

    @Override
    public void close() throws IOException {
        this.bufferedStream.close();
        this.outputStream.close();
    }

    @Override
    public OutputStream wrapAsStream() {
        return this.bufferedStream;
    }

    @Override
    public void flush() throws IOException {
        this.bufferedStream.flush();
    }

    @Override
    public void truncate(long size) throws IOException {
        this.outputStream.getChannel().truncate(size);
    }
}

