/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.exception.NotCompatibleTsFileException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.VersionUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestorableTsFileIOWriter
extends TsFileIOWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)"FileMonitor");
    private long truncatedSize = -1L;
    private Map<Path, MeasurementSchema> knownSchemas = new HashMap<Path, MeasurementSchema>();
    private int lastFlushedChunkGroupIndex = 0;
    private boolean crashed;
    private Map<String, Map<String, List<ChunkMetadata>>> metadatasForQuery = new HashMap<String, Map<String, List<ChunkMetadata>>>();

    public RestorableTsFileIOWriter(File file) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{} is opened.", (Object)file.getName());
        }
        this.file = file;
        this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(file.getPath(), true);
        if (file.length() == 0L) {
            this.startFile();
            this.crashed = true;
            this.canWrite = true;
            return;
        }
        if (file.exists()) {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
                this.truncatedSize = reader.selfCheck(this.knownSchemas, this.chunkGroupMetadataList, this.versionInfo, true);
                this.totalChunkNum = reader.getTotalChunkNum();
                if (this.truncatedSize == -1L) {
                    this.crashed = false;
                    this.canWrite = false;
                    this.out.close();
                } else {
                    if (this.truncatedSize == -3L) {
                        this.out.close();
                        throw new NotCompatibleTsFileException(String.format("%s is not in TsFile format.", file.getAbsolutePath()));
                    }
                    this.crashed = true;
                    this.canWrite = true;
                    this.out.truncate(this.truncatedSize);
                }
            }
        }
    }

    public static RestorableTsFileIOWriter getWriterForAppendingDataOnCompletedTsFile(File file) throws IOException {
        long position = file.length();
        try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
            if (reader.isComplete()) {
                reader.loadMetadataSize();
                position = reader.getFileMetadataPos();
            }
        }
        if (position != file.length()) {
            try (FileChannel channel = FileChannel.open(Paths.get(file.getAbsolutePath(), new String[0]), StandardOpenOption.WRITE);){
                channel.truncate(position - 1L);
            }
        }
        return new RestorableTsFileIOWriter(file);
    }

    long getTruncatedSize() {
        return this.truncatedSize;
    }

    public Map<Path, MeasurementSchema> getKnownSchema() {
        return this.knownSchemas;
    }

    public List<ChunkMetadata> getVisibleMetadataList(String deviceId, String measurementId, TSDataType dataType) {
        ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
        if (this.metadatasForQuery.containsKey(deviceId) && this.metadatasForQuery.get(deviceId).containsKey(measurementId)) {
            for (ChunkMetadata chunkMetaData : this.metadatasForQuery.get(deviceId).get(measurementId)) {
                if (dataType != null && !dataType.equals((Object)chunkMetaData.getDataType())) continue;
                chunkMetadataList.add(chunkMetaData);
                VersionUtils.applyVersion(chunkMetadataList, this.versionInfo);
            }
        }
        return chunkMetadataList;
    }

    public Map<String, Map<String, List<ChunkMetadata>>> getMetadatasForQuery() {
        return this.metadatasForQuery;
    }

    public void makeMetadataVisible() {
        List<ChunkGroupMetadata> newlyFlushedMetadataList = this.getAppendedRowMetadata();
        if (!newlyFlushedMetadataList.isEmpty()) {
            for (ChunkGroupMetadata chunkGroupMetadata : newlyFlushedMetadataList) {
                List<ChunkMetadata> rowMetaDataList = chunkGroupMetadata.getChunkMetadataList();
                VersionUtils.applyVersion(rowMetaDataList, this.versionInfo);
                String device = chunkGroupMetadata.getDevice();
                for (ChunkMetadata chunkMetaData : rowMetaDataList) {
                    String measurementId = chunkMetaData.getMeasurementUid();
                    if (!this.metadatasForQuery.containsKey(device)) {
                        this.metadatasForQuery.put(device, new HashMap());
                    }
                    if (!this.metadatasForQuery.get(device).containsKey(measurementId)) {
                        this.metadatasForQuery.get(device).put(measurementId, new ArrayList());
                    }
                    this.metadatasForQuery.get(device).get(measurementId).add(chunkMetaData);
                }
            }
        }
    }

    public boolean hasCrashed() {
        return this.crashed;
    }

    private List<ChunkGroupMetadata> getAppendedRowMetadata() {
        ArrayList<ChunkGroupMetadata> append = new ArrayList<ChunkGroupMetadata>();
        if (this.lastFlushedChunkGroupIndex < this.chunkGroupMetadataList.size()) {
            append.addAll(this.chunkGroupMetadataList.subList(this.lastFlushedChunkGroupIndex, this.chunkGroupMetadataList.size()));
            this.lastFlushedChunkGroupIndex = this.chunkGroupMetadataList.size();
        }
        return append;
    }

    public void addSchema(Path path, MeasurementSchema schema) {
        this.knownSchemas.put(path, schema);
    }
}

