/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.element;

import java.io.IOException;
import org.apache.iotdb.db.engine.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;

public class PointElement {
    public long timestamp;
    public long priority;
    public TimeValuePair timeValuePair;
    public IPointReader pointReader;
    public PageElement pageElement;

    public PointElement(PageElement pageElement) throws IOException {
        pageElement.deserializePage();
        this.pageElement = pageElement;
        this.pointReader = pageElement.iChunkReader instanceof ChunkReader ? pageElement.batchData.getTsBlockSingleColumnIterator() : pageElement.batchData.getTsBlockAlignedRowIterator();
        this.timeValuePair = this.pointReader.nextTimeValuePair();
        this.timestamp = this.timeValuePair.getTimestamp();
        this.priority = pageElement.priority;
    }

    public boolean hasNext() throws IOException {
        return this.pointReader.hasNextTimeValuePair();
    }

    public TimeValuePair next() throws IOException {
        this.timeValuePair = this.pointReader.nextTimeValuePair();
        this.timestamp = this.timeValuePair.getTimestamp();
        return this.timeValuePair;
    }
}

