/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.selector.estimator;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;

public abstract class AbstractCompactionEstimator {
    protected Map<TsFileResource, TsFileSequenceReader> fileReaderCache = new HashMap<TsFileResource, TsFileSequenceReader>();
    protected IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected long compressionRatio = (long)CompressionRatio.getInstance().getRatio() + 1L;

    public abstract long estimateCrossCompactionMemory(List<TsFileResource> var1, TsFileResource var2) throws IOException;

    public abstract long estimateInnerCompactionMemory(List<TsFileResource> var1);

    protected TsFileSequenceReader getFileReader(TsFileResource tsFileResource) throws IOException {
        TsFileSequenceReader reader = this.fileReaderCache.get(tsFileResource);
        if (reader == null) {
            reader = new TsFileSequenceReader(tsFileResource.getTsFilePath(), true, false);
            this.fileReaderCache.put(tsFileResource, reader);
        }
        return reader;
    }

    public void close() throws IOException {
        for (TsFileSequenceReader reader : this.fileReaderCache.values()) {
            reader.close();
        }
        this.fileReaderCache.clear();
    }
}

