/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.io.ModificationReader;
import org.apache.iotdb.db.engine.modification.io.ModificationWriter;
import org.apache.iotdb.db.engine.modification.utils.TracedBufferedReader;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTextModificationAccessor
implements ModificationReader,
ModificationWriter,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LocalTextModificationAccessor.class);
    private static final String SEPARATOR = ",";
    private static final String ABORT_MARK = "aborted";
    private String filePath;
    private BufferedWriter writer;

    public LocalTextModificationAccessor(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public Collection<Modification> read() {
        File file = FSFactoryProducer.getFSFactory().getFile(this.filePath);
        if (!file.exists()) {
            logger.debug("No modification has been written to this file");
            return new ArrayList<Modification>();
        }
        long truncatedSize = 0L;
        boolean crashed = false;
        ArrayList<Modification> modificationList = new ArrayList<Modification>();
        try (TracedBufferedReader reader = new TracedBufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.equals(ABORT_MARK) && !modificationList.isEmpty()) {
                    modificationList.remove(modificationList.size() - 1);
                } else {
                    modificationList.add(LocalTextModificationAccessor.decodeModification(line));
                }
                truncatedSize = reader.position();
            }
        }
        catch (IOException e) {
            crashed = true;
            logger.error("An error occurred when reading modifications, and the remaining modifications will be truncated to size {}.", (Object)truncatedSize, (Object)e);
        }
        if (crashed) {
            try (FileOutputStream outputStream = new FileOutputStream(file, true);){
                outputStream.getChannel().truncate(truncatedSize);
            }
            catch (FileNotFoundException e) {
                logger.debug("No modification has been written to this file");
            }
            catch (IOException e) {
                logger.error("An error occurred when truncating modifications to size {}.", (Object)truncatedSize, (Object)e);
            }
        }
        return modificationList;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void abort() throws IOException {
        if (this.writer == null) {
            this.writer = FSFactoryProducer.getFSFactory().getBufferedWriter(this.filePath, true);
        }
        this.writer.write(ABORT_MARK);
        this.writer.newLine();
        this.writer.flush();
    }

    @Override
    public void write(Modification mod) throws IOException {
        if (this.writer == null) {
            this.writer = FSFactoryProducer.getFSFactory().getBufferedWriter(this.filePath, true);
        }
        this.writer.write(LocalTextModificationAccessor.encodeModification(mod));
        this.writer.newLine();
        this.writer.flush();
    }

    private static String encodeModification(Modification mod) {
        if (mod instanceof Deletion) {
            return LocalTextModificationAccessor.encodeDeletion((Deletion)mod);
        }
        return null;
    }

    private static Modification decodeModification(String src) throws IOException {
        String[] fields = src.split(SEPARATOR);
        if (Modification.Type.DELETION.name().equals(fields[0])) {
            return LocalTextModificationAccessor.decodeDeletion(fields);
        }
        throw new IOException("Unknown modification type: " + fields[0]);
    }

    private static String encodeDeletion(Deletion del) {
        return (Object)((Object)del.getType()) + SEPARATOR + del.getPathString() + SEPARATOR + del.getFileOffset() + SEPARATOR + del.getStartTime() + SEPARATOR + del.getEndTime();
    }

    private static Deletion decodeDeletion(String[] fields) throws IOException {
        long startTimestamp;
        long endTimestamp;
        long tsFileOffset;
        if (fields.length < 4) {
            throw new IOException("Incorrect deletion fields number: " + fields.length);
        }
        String path = "";
        try {
            tsFileOffset = Long.parseLong(fields[fields.length - 3]);
        }
        catch (NumberFormatException e) {
            return LocalTextModificationAccessor.decodePointDeletion(fields);
        }
        try {
            endTimestamp = Long.parseLong(fields[fields.length - 1]);
            startTimestamp = Long.parseLong(fields[fields.length - 2]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid timestamp: " + e.getMessage());
        }
        try {
            CharSequence[] pathArray = Arrays.copyOfRange(fields, 1, fields.length - 3);
            path = String.join((CharSequence)SEPARATOR, pathArray);
            return new Deletion(new PartialPath(path), tsFileOffset, startTimestamp, endTimestamp);
        }
        catch (IllegalPathException e) {
            throw new IOException("Invalid series path: " + path);
        }
    }

    private static Deletion decodePointDeletion(String[] fields) throws IOException {
        long versionNum;
        long endTimestamp;
        String path = "";
        try {
            endTimestamp = Long.parseLong(fields[fields.length - 1]);
            versionNum = Long.parseLong(fields[fields.length - 2]);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid timestamp: " + e.getMessage());
        }
        try {
            CharSequence[] pathArray = Arrays.copyOfRange(fields, 1, fields.length - 2);
            path = String.join((CharSequence)SEPARATOR, pathArray);
            return new Deletion(new PartialPath(path), versionNum, endTimestamp);
        }
        catch (IllegalPathException e) {
            throw new IOException("Invalid series path: " + path);
        }
    }
}

