/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.sink.forward;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.trigger.sink.api.Event;
import org.apache.iotdb.tsfile.utils.Binary;

public class ForwardEvent
implements Event {
    private final long timestamp;
    private final Object value;
    private final PartialPath fullPath;
    private static final String PAYLOAD_FORMATTER = "{\"device\":\"%s\",\"measurement\":\"%s\",\"timestamp\":%d,\"value\":%s}";
    public static final String PAYLOADS_FORMATTER_REGEX = "\\[(\\{\"device\":\".*\",\"measurement\":\".*\",\"timestamp\":\\d*,\"value\":.*},)*(\\{\"device\":\".*\",\"measurement\":\".*\",\"timestamp\":\\d*,\"value\":.*})]";

    public ForwardEvent(long timestamp, Object value, PartialPath fullPath) {
        this.timestamp = timestamp;
        this.value = value;
        this.fullPath = fullPath;
    }

    public String toJsonString() {
        return String.format(PAYLOAD_FORMATTER, this.fullPath.getDevice(), this.fullPath.getMeasurement(), this.timestamp, ForwardEvent.objectToJson(this.value));
    }

    private static String objectToJson(Object object) {
        return object instanceof String || object instanceof Binary ? '\"' + object.toString() + '\"' : object.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public PartialPath getFullPath() {
        return this.fullPath;
    }
}

