/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.schemafile.impl;

import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.schemafile.ICachedMNode;
import org.apache.iotdb.db.metadata.mnode.schemafile.basic.CachedBasicMNode;
import org.apache.iotdb.db.metadata.mnode.schemafile.container.CachedMNodeContainer;

public class CachedBasicInternalMNode
extends CachedBasicMNode {
    private volatile transient IMNodeContainer<ICachedMNode> children = null;

    public CachedBasicInternalMNode(ICachedMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey((Object)name);
    }

    @Override
    public ICachedMNode getChild(String name) {
        ICachedMNode child = null;
        if (this.children != null) {
            child = (ICachedMNode)this.children.get((Object)name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedMNode addChild(String name, ICachedMNode child) {
        if (this.children == null) {
            CachedBasicInternalMNode cachedBasicInternalMNode = this;
            synchronized (cachedBasicInternalMNode) {
                if (this.children == null) {
                    this.children = new CachedMNodeContainer();
                }
            }
        }
        child.setParent(this);
        ICachedMNode existingChild = (ICachedMNode)this.children.putIfAbsent((Object)name, (Object)child);
        return existingChild == null ? child : existingChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedMNode addChild(ICachedMNode child) {
        if (this.children == null) {
            CachedBasicInternalMNode cachedBasicInternalMNode = this;
            synchronized (cachedBasicInternalMNode) {
                if (this.children == null) {
                    this.children = new CachedMNodeContainer();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent((Object)child.getName(), (Object)child);
        return child;
    }

    @Override
    public ICachedMNode deleteChild(String name) {
        if (this.children != null) {
            return (ICachedMNode)this.children.remove((Object)name);
        }
        return null;
    }

    @Override
    public synchronized void replaceChild(String oldChildName, ICachedMNode newChildNode) {
        if (!oldChildName.equals(newChildNode.getName())) {
            throw new RuntimeException("New child's name must be the same as old child's name!");
        }
        ICachedMNode oldChildNode = this.getChild(oldChildName);
        if (oldChildNode == null) {
            return;
        }
        oldChildNode.moveDataToNewMNode(newChildNode);
        this.children.replace((Object)newChildNode.getName(), (Object)newChildNode);
    }

    @Override
    public void moveDataToNewMNode(ICachedMNode newMNode) {
        super.moveDataToNewMNode(newMNode);
        if (this.children != null) {
            newMNode.setChildren(this.children);
            this.children.forEach((childName, childNode) -> childNode.setParent(newMNode));
        }
    }

    @Override
    public IMNodeContainer<ICachedMNode> getChildren() {
        if (this.children == null) {
            return CachedMNodeContainer.emptyMNodeContainer();
        }
        return this.children;
    }

    @Override
    public void setChildren(IMNodeContainer<ICachedMNode> children) {
        this.children = children;
    }

    @Override
    public int estimateSize() {
        return 280 + super.estimateSize();
    }

    @Override
    public ICachedMNode getAsMNode() {
        return this;
    }
}

