/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.utils;

import java.util.Iterator;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class MNodeUtils {
    public static <N extends IMNode<N>> IDeviceMNode<N> setToEntity(IMNode<N> node, IMNodeFactory<N> nodeFactory) {
        IDeviceMNode entityMNode;
        if (node.isDevice()) {
            entityMNode = node.getAsDeviceMNode();
        } else if (node.isDatabase()) {
            entityMNode = nodeFactory.createDatabaseDeviceMNode(node.getParent(), node.getName(), node.getAsDatabaseMNode().getDataTTL()).getAsDeviceMNode();
            node.moveDataToNewMNode(entityMNode.getAsMNode());
        } else {
            entityMNode = nodeFactory.createDeviceMNode(node.getParent(), node.getName());
            if (node.getParent() != null) {
                node.getParent().replaceChild(node.getName(), entityMNode.getAsMNode());
            } else {
                node.moveDataToNewMNode(entityMNode.getAsMNode());
            }
        }
        return entityMNode;
    }

    public static <N extends IMNode<N>> N setToInternal(IDeviceMNode<N> entityMNode, IMNodeFactory<N> nodeFactor) {
        IMNode node;
        IMNode parent = entityMNode.getParent();
        if (entityMNode.isDatabase()) {
            IDatabaseMNode databaseMNode = nodeFactor.createDatabaseMNode(parent, entityMNode.getName());
            databaseMNode.setDataTTL(entityMNode.getAsDatabaseMNode().getDataTTL());
            node = databaseMNode.getAsMNode();
        } else {
            node = nodeFactor.createInternalMNode(parent, entityMNode.getName());
        }
        if (parent != null) {
            parent.replaceChild(entityMNode.getName(), node);
        }
        return (N)node;
    }

    public static <N extends IMNode<N>> N getChild(Template template, String name, IMNodeFactory<N> nodeFactor) {
        IMeasurementSchema schema = template.getSchema(name);
        return (N)(schema == null ? null : nodeFactor.createMeasurementMNode(null, name, template.getSchema(name), null).getAsMNode());
    }

    public static <N extends IMNode<N>> Iterator<N> getChildren(final Template template, final IMNodeFactory<N> nodeFactor) {
        return new Iterator<N>(){
            private final Iterator<IMeasurementSchema> schemas;
            {
                this.schemas = template.getSchemaMap().values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.schemas.hasNext();
            }

            @Override
            public N next() {
                IMeasurementSchema schema = this.schemas.next();
                return nodeFactor.createMeasurementMNode(null, schema.getMeasurementId(), schema, null).getAsMNode();
            }
        };
    }
}

