/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store;

import java.io.File;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.db.metadata.mnode.config.IConfigMNode;
import org.apache.iotdb.db.metadata.mnode.mem.iterator.MNodeIterator;
import org.apache.iotdb.db.metadata.mnode.mem.iterator.MemoryTraverserIterator;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.template.Template;

public class ConfigMTreeStore
implements IMTreeStore<IConfigMNode> {
    private IConfigMNode root;
    private final IMNodeFactory<IConfigMNode> nodeFactory;

    public ConfigMTreeStore(IMNodeFactory<IConfigMNode> nodeFactory) {
        this.root = (IConfigMNode)nodeFactory.createInternalMNode(null, "root");
        this.nodeFactory = nodeFactory;
    }

    @Override
    public IConfigMNode generatePrefix(PartialPath storageGroupPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConfigMNode getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChild(IConfigMNode parent, String name) {
        return parent.hasChild(name);
    }

    @Override
    public IConfigMNode getChild(IConfigMNode parent, String name) {
        return (IConfigMNode)parent.getChild(name);
    }

    @Override
    public IMNodeIterator<IConfigMNode> getChildrenIterator(IConfigMNode parent) {
        return new MNodeIterator<IConfigMNode>(parent.getChildren().values().iterator());
    }

    @Override
    public IMNodeIterator<IConfigMNode> getTraverserIterator(IConfigMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        if (parent.isDevice()) {
            MemoryTraverserIterator<IConfigMNode> iterator = new MemoryTraverserIterator<IConfigMNode>(this, parent.getAsDeviceMNode(), templateMap, this.nodeFactory);
            iterator.setSkipPreDeletedSchema(skipPreDeletedSchema);
            return iterator;
        }
        return this.getChildrenIterator(parent);
    }

    @Override
    public IConfigMNode addChild(IConfigMNode parent, String childName, IConfigMNode child) {
        return (IConfigMNode)parent.addChild(childName, child);
    }

    @Override
    public void deleteChild(IConfigMNode parent, String childName) {
        parent.deleteChild(childName);
    }

    @Override
    public void updateMNode(IConfigMNode node) {
    }

    @Override
    public IDeviceMNode<IConfigMNode> setToEntity(IConfigMNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConfigMNode setToInternal(IDeviceMNode<IConfigMNode> entityMNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlias(IMeasurementMNode<IConfigMNode> measurementMNode, String alias) {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        measurementMNode.setAlias(alias);
    }

    @Override
    public void pin(IConfigMNode node) {
    }

    @Override
    public void unPin(IConfigMNode node) {
    }

    @Override
    public void unPinPath(IConfigMNode node) {
    }

    @Override
    public IMTreeStore getWithReentrantReadLock() {
        return this;
    }

    @Override
    public void clear() {
        this.root = (IConfigMNode)this.nodeFactory.createInternalMNode(null, "root");
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        throw new UnsupportedOperationException();
    }
}

