/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.query.info;

import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.db.metadata.query.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class TimeseriesSchemaInfo
implements ITimeSeriesSchemaInfo {
    private final IMeasurementMNode<?> node;
    private final PartialPath fullPath;
    private final Map<String, String> tags;
    private final Map<String, String> attributes;
    private final boolean isUnderAlignedDevice;

    public TimeseriesSchemaInfo(IMeasurementMNode<?> node, PartialPath fullPath, Map<String, String> tags, Map<String, String> attributes, boolean isUnderAlignedDevice) {
        this.node = node;
        this.fullPath = fullPath;
        this.tags = tags;
        this.attributes = attributes;
        this.isUnderAlignedDevice = isUnderAlignedDevice;
    }

    @Override
    public String getFullPath() {
        return this.fullPath.getFullPath();
    }

    @Override
    public PartialPath getPartialPath() {
        return this.fullPath;
    }

    @Override
    public String getAlias() {
        return this.node.getAlias();
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.node.getSchema();
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isUnderAlignedDevice() {
        return this.isUnderAlignedDevice;
    }

    @Override
    public boolean isLogicalView() {
        return this.node.isLogicalView();
    }

    @Override
    public ITimeSeriesSchemaInfo snapshot() {
        return this;
    }
}

