/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegionParams;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegion;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaRegionLoader {
    private static final Logger logger = LoggerFactory.getLogger(SchemaEngine.class);
    private static final String PACKAGE_NAME = "org.apache.iotdb.db.metadata";
    private final Map<String, Constructor<ISchemaRegion>> constructorMap = new ConcurrentHashMap<String, Constructor<ISchemaRegion>>();
    private String currentMode;
    private Constructor<ISchemaRegion> currentConstructor;

    SchemaRegionLoader() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(new String[]{PACKAGE_NAME}).filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{PACKAGE_NAME})));
        Set annotatedSchemaRegionSet = reflections.getTypesAnnotatedWith(SchemaRegion.class);
        for (Class annotatedSchemaRegion : annotatedSchemaRegionSet) {
            boolean isSchemaRegion = false;
            for (Class<?> interfaces : annotatedSchemaRegion.getInterfaces()) {
                if (interfaces != ISchemaRegion.class) continue;
                isSchemaRegion = true;
                break;
            }
            if (!isSchemaRegion) {
                logger.warn(String.format("Class %s is not a subclass of ISchemaRegion.", annotatedSchemaRegion.getName()));
                continue;
            }
            SchemaRegion annotationInfo = annotatedSchemaRegion.getAnnotation(SchemaRegion.class);
            this.constructorMap.compute(annotationInfo.mode(), (k, v) -> {
                if (v == null) {
                    try {
                        return annotatedSchemaRegion.getConstructor(ISchemaRegionParams.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
                logger.warn("Duplicated SchemaRegion implementation, {} and {}, with same mode name [{}]", new Object[]{v.getClass().getName(), annotatedSchemaRegion.getName(), k});
                return v;
            });
        }
    }

    void init(String schemaEngineMode) {
        Constructor<ISchemaRegion> constructor = this.constructorMap.get(schemaEngineMode);
        if (constructor == null) {
            logger.warn("There's no SchemaRegion implementation with target mode {}. Use default mode {}", (Object)schemaEngineMode, (Object)"Memory");
            this.currentMode = "Memory";
            this.currentConstructor = this.constructorMap.get(this.currentMode);
        } else {
            this.currentMode = schemaEngineMode;
            this.currentConstructor = constructor;
        }
    }

    ISchemaRegion createSchemaRegion(ISchemaRegionParams schemaRegionParams) throws MetadataException {
        try {
            return this.currentConstructor.newInstance(schemaRegionParams);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new MetadataException((Throwable)e);
        }
    }

    void clear() {
        this.currentMode = null;
        this.currentConstructor = null;
    }
}

