/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation.timerangeiterator;

import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public class AggrWindowIterator
implements ITimeRangeIterator {
    private final long startTime;
    private final long endTime;
    private final long interval;
    private final long slidingStep;
    private final boolean isAscending;
    private final boolean isSlidingStepByMonth;
    private final boolean isIntervalByMonth;
    private final boolean leftCRightO;
    private TimeRange curTimeRange;
    private boolean hasCachedTimeRange;

    public AggrWindowIterator(long startTime, long endTime, long interval, long slidingStep, boolean isAscending, boolean isSlidingStepByMonth, boolean isIntervalByMonth, boolean leftCRightO) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
        this.isAscending = isAscending;
        this.isSlidingStepByMonth = isSlidingStepByMonth;
        this.isIntervalByMonth = isIntervalByMonth;
        this.leftCRightO = leftCRightO;
    }

    @Override
    public TimeRange getFirstTimeRange() {
        if (this.isAscending) {
            return this.getLeftmostTimeRange();
        }
        return this.getRightmostTimeRange();
    }

    private TimeRange getLeftmostTimeRange() {
        long retEndTime = this.isIntervalByMonth ? Math.min(DateTimeUtils.calcIntervalByMonth(this.startTime, this.interval), this.endTime) : Math.min(this.startTime + this.interval, this.endTime);
        return new TimeRange(this.startTime, retEndTime);
    }

    private TimeRange getRightmostTimeRange() {
        long retStartTime;
        long queryRange = this.endTime - this.startTime;
        if (this.isSlidingStepByMonth) {
            long intervalNum = (long)Math.ceil((double)queryRange / (double)(this.slidingStep * 2592000000L));
            retStartTime = DateTimeUtils.calcIntervalByMonth(this.startTime, intervalNum * this.slidingStep);
            while (retStartTime >= this.endTime) {
                retStartTime = DateTimeUtils.calcIntervalByMonth(this.startTime, --intervalNum * this.slidingStep);
            }
        } else {
            long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
            retStartTime = this.slidingStep * (intervalNum - 1L) + this.startTime;
        }
        long retEndTime = this.isIntervalByMonth ? Math.min(DateTimeUtils.calcIntervalByMonth(retStartTime, this.interval), this.endTime) : Math.min(retStartTime + this.interval, this.endTime);
        return new TimeRange(retStartTime, retEndTime);
    }

    @Override
    public boolean hasNextTimeRange() {
        long retStartTime;
        if (this.hasCachedTimeRange) {
            return true;
        }
        if (this.curTimeRange == null) {
            this.curTimeRange = this.getFirstTimeRange();
            this.hasCachedTimeRange = true;
            return true;
        }
        long curStartTime = this.curTimeRange.getMin();
        if (this.isAscending ? (retStartTime = this.isSlidingStepByMonth ? DateTimeUtils.calcIntervalByMonth(curStartTime, (int)this.slidingStep) : curStartTime + this.slidingStep) >= this.endTime : (retStartTime = this.isSlidingStepByMonth ? DateTimeUtils.calcIntervalByMonth(curStartTime, (int)(-this.slidingStep)) : curStartTime - this.slidingStep) < this.startTime) {
            return false;
        }
        long retEndTime = this.isIntervalByMonth ? DateTimeUtils.calcIntervalByMonth(retStartTime, (int)this.interval) : retStartTime + this.interval;
        retEndTime = Math.min(retEndTime, this.endTime);
        this.curTimeRange = new TimeRange(retStartTime, retEndTime);
        this.hasCachedTimeRange = true;
        return true;
    }

    @Override
    public TimeRange nextTimeRange() {
        if (this.hasCachedTimeRange || this.hasNextTimeRange()) {
            this.hasCachedTimeRange = false;
            return this.getFinalTimeRange(this.curTimeRange, this.leftCRightO);
        }
        return null;
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }

    @Override
    public long currentOutputTime() {
        return this.leftCRightO ? this.curTimeRange.getMin() : this.curTimeRange.getMax();
    }

    @Override
    public long getTotalIntervalNum() {
        long intervalNum;
        long queryRange = this.endTime - this.startTime;
        if (this.isSlidingStepByMonth) {
            intervalNum = (long)Math.ceil((double)queryRange / (double)(this.slidingStep * 2592000000L));
            long retStartTime = DateTimeUtils.calcIntervalByMonth(this.startTime, intervalNum * this.slidingStep);
            while (retStartTime > this.endTime) {
                retStartTime = DateTimeUtils.calcIntervalByMonth(this.startTime, --intervalNum * this.slidingStep);
            }
        } else {
            intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
        }
        return intervalNum;
    }

    public void reset() {
        this.curTimeRange = null;
        this.hasCachedTimeRange = false;
    }
}

