/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.driver;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.IDataRegionForQuery;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.operator.source.DataSourceOperator;

public class DataDriverContext
extends DriverContext {
    private final List<PartialPath> paths = new ArrayList<PartialPath>();
    private final List<DataSourceOperator> sourceOperators = new ArrayList<DataSourceOperator>();

    public DataDriverContext(FragmentInstanceContext fragmentInstanceContext, int pipelineId) {
        super(fragmentInstanceContext, pipelineId);
    }

    public DataDriverContext(DataDriverContext parentContext, int pipelineId) {
        super(parentContext.getFragmentInstanceContext(), pipelineId);
    }

    public void addPath(PartialPath path) {
        this.paths.add(path);
    }

    public void addSourceOperator(DataSourceOperator sourceOperator) {
        this.sourceOperators.add(sourceOperator);
    }

    public List<PartialPath> getPaths() {
        return this.paths;
    }

    public IDataRegionForQuery getDataRegion() {
        return this.getFragmentInstanceContext().getDataRegion();
    }

    public QueryDataSource getSharedQueryDataSource() throws QueryProcessException {
        return this.getFragmentInstanceContext().getSharedQueryDataSource();
    }

    public List<DataSourceOperator> getSourceOperators() {
        return this.sourceOperators;
    }

    @Override
    public DriverContext createSubDriverContext(int pipelineId) {
        return new DataDriverContext(this, pipelineId);
    }
}

