/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.window;

import org.apache.iotdb.db.mpp.execution.operator.window.VariationFloatWindow;
import org.apache.iotdb.db.mpp.execution.operator.window.VariationWindowManager;
import org.apache.iotdb.db.mpp.execution.operator.window.VariationWindowParameter;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;

public class VariationFloatWindowManager
extends VariationWindowManager {
    public VariationFloatWindowManager(VariationWindowParameter variationWindowParameter, boolean ascending) {
        super(ascending);
        this.variationWindow = new VariationFloatWindow(variationWindowParameter);
    }

    @Override
    public TsBlock skipPointsOutOfCurWindow(TsBlock inputTsBlock) {
        int i;
        if (!this.needSkip) {
            return inputTsBlock;
        }
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return inputTsBlock;
        }
        Column controlColumn = this.variationWindow.getControlColumn(inputTsBlock);
        TimeColumn timeColumn = inputTsBlock.getTimeColumn();
        int size = inputTsBlock.getPositionCount();
        float previousValue = ((VariationFloatWindow)this.variationWindow).getPreviousHeadValue();
        boolean previousValueIsNull = ((VariationFloatWindow)this.variationWindow).valueIsNull();
        for (i = 0; i < size; ++i) {
            boolean condition = false;
            boolean isNull = controlColumn.isNull(i);
            if (!isNull) {
                boolean bl = condition = (double)Math.abs(controlColumn.getFloat(i) - previousValue) > this.variationWindow.getDelta();
            }
            if (this.isIgnoringNull()) {
                if (!isNull && condition) break;
                if (isNull) {
                    continue;
                }
            } else if (isNull && !previousValueIsNull || !isNull && previousValueIsNull || !isNull && condition) break;
            long currentTime = timeColumn.getLong(i);
            if (this.variationWindow.getStartTime() > currentTime) {
                this.variationWindow.setStartTime(currentTime);
            }
            if (this.variationWindow.getEndTime() >= currentTime) continue;
            this.variationWindow.setEndTime(currentTime);
        }
        if (i < size) {
            this.needSkip = false;
        }
        return inputTsBlock.subTsBlock(i);
    }
}

