/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryExecutionMetricSet
implements IMetricSet {
    private static final QueryExecutionMetricSet INSTANCE = new QueryExecutionMetricSet();
    public static final String WAIT_FOR_DISPATCH = "wait_for_dispatch";
    public static final String DISPATCH_READ = "dispatch_read";
    private Timer waitForDispatchTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer dispatchReadTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    public static final String LOCAL_EXECUTION_PLANNER = "local_execution_planner";
    public static final String QUERY_RESOURCE_INIT = "query_resource_init";
    public static final String GET_QUERY_RESOURCE_FROM_MEM = "get_query_resource_from_mem";
    public static final String DRIVER_INTERNAL_PROCESS = "driver_internal_process";
    public static final String WAIT_FOR_RESULT = "wait_for_result";
    private Timer localExecutionPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer queryResourceInitTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer getQueryResourceFromMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer driverInternalProcessTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer waitForResultTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    public static final String AGGREGATION_FROM_RAW_DATA = "aggregation_from_raw_data";
    public static final String AGGREGATION_FROM_STATISTICS = "aggregation_from_statistics";
    private Timer aggregationFromRawDataTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer aggregationFromStatisticsTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private QueryExecutionMetricSet() {
    }

    private void bindQueryDispatch(AbstractMetricService metricService) {
        this.waitForDispatchTimer = metricService.getOrCreateTimer(Metric.DISPATCHER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), WAIT_FOR_DISPATCH});
        this.dispatchReadTimer = metricService.getOrCreateTimer(Metric.DISPATCHER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), DISPATCH_READ});
    }

    private void unbindQueryDispatch(AbstractMetricService metricService) {
        this.waitForDispatchTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.dispatchReadTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(WAIT_FOR_DISPATCH, DISPATCH_READ).forEach(stage -> metricService.remove(MetricType.TIMER, Metric.DISPATCHER.toString(), new String[]{Tag.STAGE.toString(), stage}));
    }

    private void bindQueryExecution(AbstractMetricService metricService) {
        this.localExecutionPlannerTimer = metricService.getOrCreateTimer(Metric.QUERY_EXECUTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOCAL_EXECUTION_PLANNER});
        this.queryResourceInitTimer = metricService.getOrCreateTimer(Metric.QUERY_EXECUTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), QUERY_RESOURCE_INIT});
        this.getQueryResourceFromMemTimer = metricService.getOrCreateTimer(Metric.QUERY_EXECUTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), GET_QUERY_RESOURCE_FROM_MEM});
        this.driverInternalProcessTimer = metricService.getOrCreateTimer(Metric.QUERY_EXECUTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), DRIVER_INTERNAL_PROCESS});
        this.waitForResultTimer = metricService.getOrCreateTimer(Metric.QUERY_EXECUTION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), WAIT_FOR_RESULT});
    }

    private void unbindQueryExecution(AbstractMetricService metricService) {
        this.localExecutionPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.queryResourceInitTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.getQueryResourceFromMemTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.driverInternalProcessTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.waitForResultTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList(LOCAL_EXECUTION_PLANNER, QUERY_RESOURCE_INIT, GET_QUERY_RESOURCE_FROM_MEM, DRIVER_INTERNAL_PROCESS, WAIT_FOR_RESULT).forEach(stage -> metricService.remove(MetricType.TIMER, Metric.QUERY_EXECUTION.toString(), new String[]{Tag.STAGE.toString(), stage}));
    }

    private void bindQueryAggregation(AbstractMetricService metricService) {
        this.aggregationFromRawDataTimer = metricService.getOrCreateTimer(Metric.AGGREGATION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.FROM.toString(), "raw_data"});
        this.aggregationFromStatisticsTimer = metricService.getOrCreateTimer(Metric.AGGREGATION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.FROM.toString(), "statistics"});
    }

    private void unbindQueryAggregation(AbstractMetricService metricService) {
        this.aggregationFromRawDataTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.aggregationFromStatisticsTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        Arrays.asList("raw_data", "statistics").forEach(from -> metricService.remove(MetricType.TIMER, Metric.AGGREGATION.toString(), new String[]{Tag.FROM.toString(), from}));
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindQueryExecution(metricService);
        this.bindQueryDispatch(metricService);
        this.bindQueryAggregation(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindQueryExecution(metricService);
        this.unbindQueryDispatch(metricService);
        this.unbindQueryAggregation(metricService);
    }

    public void recordExecutionCost(String stage, long costTimeInNanos) {
        switch (stage) {
            case "wait_for_dispatch": {
                this.waitForDispatchTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "dispatch_read": {
                this.dispatchReadTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "local_execution_planner": {
                this.localExecutionPlannerTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "query_resource_init": {
                this.queryResourceInitTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "get_query_resource_from_mem": {
                this.getQueryResourceFromMemTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "driver_internal_process": {
                this.driverInternalProcessTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "wait_for_result": {
                this.waitForResultTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "aggregation_from_raw_data": {
                this.aggregationFromRawDataTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
            case "aggregation_from_statistics": {
                this.aggregationFromStatisticsTimer.update(costTimeInNanos, TimeUnit.NANOSECONDS);
                break;
            }
        }
    }

    public static QueryExecutionMetricSet getInstance() {
        return INSTANCE;
    }
}

