/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class QueryMetricsManager {
    private final MetricService metricService = MetricService.getInstance();

    public void recordOperatorExecutionCost(String operatorType, long costTimeInNanos) {
        this.metricService.timer(costTimeInNanos, TimeUnit.NANOSECONDS, Metric.OPERATOR_EXECUTION_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), operatorType});
    }

    public void recordOperatorExecutionCount(String operatorType, long count) {
        this.metricService.count(count, Metric.OPERATOR_EXECUTION_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), operatorType});
    }

    public static QueryMetricsManager getInstance() {
        return QueryMetricsManagerHolder.INSTANCE;
    }

    private static class QueryMetricsManagerHolder {
        private static final QueryMetricsManager INSTANCE = new QueryMetricsManager();

        private QueryMetricsManagerHolder() {
        }
    }
}

