/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.metric;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.mpp.execution.memory.MemoryPool;
import org.apache.iotdb.db.mpp.plan.Coordinator;
import org.apache.iotdb.db.mpp.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryRelatedResourceMetricSet
implements IMetricSet {
    private static final Coordinator coordinator = Coordinator.getInstance();
    private static final String COORDINATOR = Metric.COORDINATOR.toString();
    private static final String QUERY_EXECUTION_MAP_SIZE = "query_execution_map_size";
    private static final FragmentInstanceManager fragmentInstanceManager = FragmentInstanceManager.getInstance();
    private static final String FRAGMENT_INSTANCE_MANAGER = Metric.FRAGMENT_INSTANCE_MANAGER.toString();
    private static final String INSTANCE_CONTEXT_SIZE = "instance_context_size";
    private static final String INSTANCE_EXECUTION_SIZE = "instance_execution_size";
    private static final MemoryPool memoryPool = MPPDataExchangeService.getInstance().getMPPDataExchangeManager().getLocalMemoryManager().getQueryPool();
    private static final String MEMORY_POOL = Metric.MEMORY_POOL.toString();
    private static final String MAX_BYTES = "max_bytes";
    private static final String REMAINING_BYTES = "remaining_bytes";
    private static final String QUERY_MEMORY_RESERVATION_SIZE = "query_memory_reservation_size";
    private static final String MEMORY_RESERVATION_SIZE = "memory_reservation_size";
    private static final LocalExecutionPlanner localExecutionPlanner = LocalExecutionPlanner.getInstance();
    private static final String LOCAL_EXECUTION_PLANNER = Metric.LOCAL_EXECUTION_PLANNER.toString();
    private static final String FREE_MEMORY_FOR_OPERATORS = "free_memory_for_operators";

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(COORDINATOR, MetricLevel.IMPORTANT, (Object)coordinator, Coordinator::getQueryExecutionMapSize, new String[]{Tag.NAME.toString(), QUERY_EXECUTION_MAP_SIZE});
        metricService.createAutoGauge(FRAGMENT_INSTANCE_MANAGER, MetricLevel.IMPORTANT, (Object)fragmentInstanceManager, FragmentInstanceManager::getInstanceContextSize, new String[]{Tag.NAME.toString(), INSTANCE_CONTEXT_SIZE});
        metricService.createAutoGauge(FRAGMENT_INSTANCE_MANAGER, MetricLevel.IMPORTANT, (Object)fragmentInstanceManager, FragmentInstanceManager::getInstanceExecutionSize, new String[]{Tag.NAME.toString(), INSTANCE_EXECUTION_SIZE});
        metricService.getOrCreateGauge(MEMORY_POOL, MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), MAX_BYTES}).set(memoryPool.getMaxBytes());
        metricService.createAutoGauge(MEMORY_POOL, MetricLevel.IMPORTANT, (Object)memoryPool, MemoryPool::getRemainingBytes, new String[]{Tag.NAME.toString(), REMAINING_BYTES});
        metricService.createAutoGauge(MEMORY_POOL, MetricLevel.IMPORTANT, (Object)memoryPool, MemoryPool::getQueryMemoryReservationSize, new String[]{Tag.NAME.toString(), QUERY_MEMORY_RESERVATION_SIZE});
        metricService.createAutoGauge(MEMORY_POOL, MetricLevel.IMPORTANT, (Object)memoryPool, MemoryPool::getMemoryReservationSize, new String[]{Tag.NAME.toString(), MEMORY_RESERVATION_SIZE});
        metricService.createAutoGauge(LOCAL_EXECUTION_PLANNER, MetricLevel.IMPORTANT, (Object)localExecutionPlanner, LocalExecutionPlanner::getFreeMemoryForOperators, new String[]{Tag.NAME.toString(), FREE_MEMORY_FOR_OPERATORS});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, COORDINATOR, new String[]{Tag.NAME.toString(), QUERY_EXECUTION_MAP_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, FRAGMENT_INSTANCE_MANAGER, new String[]{Tag.NAME.toString(), INSTANCE_CONTEXT_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, FRAGMENT_INSTANCE_MANAGER, new String[]{Tag.NAME.toString(), INSTANCE_EXECUTION_SIZE});
        metricService.remove(MetricType.GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), MAX_BYTES});
        metricService.remove(MetricType.AUTO_GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), REMAINING_BYTES});
        metricService.remove(MetricType.AUTO_GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), QUERY_MEMORY_RESERVATION_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, MEMORY_POOL, new String[]{Tag.NAME.toString(), MEMORY_RESERVATION_SIZE});
        metricService.remove(MetricType.AUTO_GAUGE, LOCAL_EXECUTION_PLANNER, new String[]{Tag.NAME.toString(), FREE_MEMORY_FOR_OPERATORS});
    }
}

