/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan;

import java.util.ArrayList;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.client.IoTConsensusClientPool;
import org.apache.iotdb.consensus.iot.client.SyncIoTConsensusServiceClient;
import org.apache.iotdb.consensus.iot.thrift.TInactivatePeerReq;
import org.apache.iotdb.consensus.iot.thrift.TInactivatePeerRes;
import org.apache.iotdb.consensus.iot.thrift.TTriggerSnapshotLoadReq;
import org.apache.iotdb.consensus.iot.thrift.TTriggerSnapshotLoadRes;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;

public class TestRPCClient {
    private static final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> INTERNAL_SERVICE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());
    private final IClientManager<TEndPoint, SyncIoTConsensusServiceClient> syncClientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new IoTConsensusClientPool.SyncIoTConsensusServiceClientPoolFactory(new IoTConsensusConfig.Builder().build()));

    public static void main(String[] args) {
        TestRPCClient client = new TestRPCClient();
        client.addPeer();
    }

    private void loadSnapshot() {
        try (SyncIoTConsensusServiceClient client = (SyncIoTConsensusServiceClient)this.syncClientManager.borrowClient((Object)new TEndPoint("127.0.0.1", 40011));){
            TTriggerSnapshotLoadRes res = client.triggerSnapshotLoad(new TTriggerSnapshotLoadReq(new DataRegionId(1).convertToTConsensusGroupId(), "snapshot_1_1662370255552"));
            System.out.println(res.status);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void testAddPeer() {
        try (SyncIoTConsensusServiceClient client = (SyncIoTConsensusServiceClient)this.syncClientManager.borrowClient((Object)new TEndPoint("127.0.0.1", 40012));){
            TInactivatePeerRes res = client.inactivatePeer(new TInactivatePeerReq(new DataRegionId(1).convertToTConsensusGroupId()));
            System.out.println(res.status);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void removeRegionPeer() {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)INTERNAL_SERVICE_CLIENT_MANAGER.borrowClient((Object)new TEndPoint("127.0.0.1", 9003));){
            client.removeRegionPeer(new TMaintainPeerReq(new DataRegionId(1).convertToTConsensusGroupId(), this.getLocation2(3)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addPeer() {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)INTERNAL_SERVICE_CLIENT_MANAGER.borrowClient((Object)new TEndPoint("127.0.0.1", 9003));){
            client.addRegionPeer(new TMaintainPeerReq(new DataRegionId(1).convertToTConsensusGroupId(), this.getLocation2(3)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TDataNodeLocation getLocation3(int dataNodeId) {
        return new TDataNodeLocation(dataNodeId, new TEndPoint("127.0.0.1", 6669), new TEndPoint("127.0.0.1", 10732), new TEndPoint("127.0.0.1", 10742), new TEndPoint("127.0.0.1", 10762), new TEndPoint("127.0.0.1", 10752));
    }

    private TDataNodeLocation getLocation2(int dataNodeId) {
        return new TDataNodeLocation(dataNodeId, new TEndPoint("127.0.0.1", 6668), new TEndPoint("127.0.0.1", 10731), new TEndPoint("127.0.0.1", 10741), new TEndPoint("127.0.0.1", 10761), new TEndPoint("127.0.0.1", 10751));
    }

    private void createDataRegion() {
        try (SyncDataNodeInternalServiceClient client = (SyncDataNodeInternalServiceClient)INTERNAL_SERVICE_CLIENT_MANAGER.borrowClient((Object)new TEndPoint("127.0.0.1", 9005));){
            TCreateDataRegionReq req = new TCreateDataRegionReq();
            req.setStorageGroup("root.test.g_0");
            TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
            regionReplicaSet.setRegionId(new DataRegionId(1).convertToTConsensusGroupId());
            ArrayList<TDataNodeLocation> locationList = new ArrayList<TDataNodeLocation>();
            locationList.add(new TDataNodeLocation(3, new TEndPoint("127.0.0.1", 6667), new TEndPoint("127.0.0.1", 10730), new TEndPoint("127.0.0.1", 10740), new TEndPoint("127.0.0.1", 10760), new TEndPoint("127.0.0.1", 10750)));
            locationList.add(new TDataNodeLocation(4, new TEndPoint("127.0.0.1", 6668), new TEndPoint("127.0.0.1", 10731), new TEndPoint("127.0.0.1", 10741), new TEndPoint("127.0.0.1", 10761), new TEndPoint("127.0.0.1", 10751)));
            locationList.add(new TDataNodeLocation(4, new TEndPoint("127.0.0.1", 6669), new TEndPoint("127.0.0.1", 10732), new TEndPoint("127.0.0.1", 10742), new TEndPoint("127.0.0.1", 10762), new TEndPoint("127.0.0.1", 10752)));
            regionReplicaSet.setDataNodeLocations(locationList);
            req.setRegionReplicaSet(regionReplicaSet);
            TSStatus res = client.createDataRegion(req);
            System.out.println(res.code + " " + res.message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

