/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.multi.builtin.helper;

import java.util.Map;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.multi.builtin.BuiltInScalarFunctionHelper;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.unary.scalar.ReplaceFunctionColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.unary.scalar.ReplaceFunctionTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.type.TypeFactory;

public class ReplaceFunctionHelper
implements BuiltInScalarFunctionHelper {
    @Override
    public void checkBuiltInScalarFunctionInputDataType(TSDataType tsDataType) throws SemanticException {
        if (tsDataType.equals((Object)TSDataType.TEXT)) {
            return;
        }
        throw new SemanticException("Input series of Scalar function [REPLACE] only support text data type.");
    }

    @Override
    public TSDataType getBuiltInScalarFunctionReturnType(FunctionExpression functionExpression) {
        return TSDataType.TEXT;
    }

    @Override
    public ColumnTransformer getBuiltInScalarFunctionColumnTransformer(FunctionExpression expression, ColumnTransformer columnTransformer) {
        this.checkFromAndToAttributes(expression);
        return new ReplaceFunctionColumnTransformer(TypeFactory.getType((TSDataType)TSDataType.TEXT), columnTransformer, expression.getFunctionAttributes().get("FROM"), expression.getFunctionAttributes().get("TO"));
    }

    @Override
    public Transformer getBuiltInScalarFunctionTransformer(FunctionExpression expression, LayerPointReader layerPointReader) {
        this.checkFromAndToAttributes(expression);
        return new ReplaceFunctionTransformer(layerPointReader, expression.getFunctionAttributes().get("FROM"), expression.getFunctionAttributes().get("TO"));
    }

    @Override
    public void appendFunctionAttributes(boolean hasExpression, StringBuilder builder, Map<String, String> functionAttributes) {
        builder.append(", '");
        builder.append(functionAttributes.get("FROM"));
        builder.append("', '");
        builder.append(functionAttributes.get("TO"));
        builder.append("'");
    }

    private void checkFromAndToAttributes(FunctionExpression expression) {
        if (!expression.getFunctionAttributes().containsKey("FROM") || !expression.getFunctionAttributes().containsKey("TO")) {
            throw new SemanticException("Function REPLACE must specify from and to component.");
        }
    }
}

