/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.unary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.NullOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;

public class NegationExpression
extends UnaryExpression {
    public NegationExpression(Expression expression) {
        super(expression);
    }

    public NegationExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
    }

    @Override
    protected Expression constructExpression(Expression childExpression) {
        return new NegationExpression(childExpression);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.expression instanceof TimeSeriesOperand || this.expression instanceof FunctionExpression || this.expression instanceof NullOperand || this.expression instanceof ConstantOperand && !((ConstantOperand)this.expression).isNegativeNumber() ? "-" + this.expression.getExpressionString() : "-(" + this.expression.getExpressionString() + ")";
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression instanceof TimeSeriesOperand || this.expression instanceof FunctionExpression || this.expression instanceof NullOperand || this.expression instanceof ConstantOperand && !((ConstantOperand)this.expression).isNegativeNumber() ? "-" + this.expression.getOutputSymbol() : "-(" + this.expression.getOutputSymbol() + ")";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.NEGATION;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitNegationExpression(this, context);
    }
}

