/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class BatchActivateTemplateNode
extends WritePlanNode {
    private final Map<PartialPath, Pair<Integer, Integer>> templateActivationMap;
    private TRegionReplicaSet regionReplicaSet;

    public BatchActivateTemplateNode(PlanNodeId id, Map<PartialPath, Pair<Integer, Integer>> templateActivationMap) {
        super(id);
        this.templateActivationMap = templateActivationMap;
    }

    private BatchActivateTemplateNode(PlanNodeId id, Map<PartialPath, Pair<Integer, Integer>> templateActivationMap, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.templateActivationMap = templateActivationMap;
        this.regionReplicaSet = regionReplicaSet;
    }

    public Map<PartialPath, Pair<Integer, Integer>> getTemplateActivationMap() {
        return this.templateActivationMap;
    }

    public PartialPath getPathSetTemplate(PartialPath devicePath) {
        return new PartialPath(Arrays.copyOf(devicePath.getNodes(), (Integer)this.templateActivationMap.get((Object)devicePath).right + 1));
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new BatchActivateTemplateNode(this.getPlanNodeId(), this.templateActivationMap, this.regionReplicaSet);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.BATCH_ACTIVATE_TEMPLATE.serialize(byteBuffer);
        int size = this.templateActivationMap.size();
        ReadWriteIOUtils.write((int)size, (ByteBuffer)byteBuffer);
        for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : this.templateActivationMap.entrySet()) {
            entry.getKey().serialize(byteBuffer);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue().left), (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue().right), (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.BATCH_ACTIVATE_TEMPLATE.serialize(stream);
        int size = this.templateActivationMap.size();
        ReadWriteIOUtils.write((int)size, (OutputStream)stream);
        for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : this.templateActivationMap.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue().left), (OutputStream)stream);
            ReadWriteIOUtils.write((int)((Integer)entry.getValue().right), (OutputStream)stream);
        }
    }

    public static InternalBatchActivateTemplateNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashMap<PartialPath, Pair<Integer, Integer>> templateActivationMap = new HashMap<PartialPath, Pair<Integer, Integer>>(size);
        for (int i = 0; i < size; ++i) {
            templateActivationMap.put((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer), (Pair<Integer, Integer>)new Pair((Object)ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer), (Object)ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new InternalBatchActivateTemplateNode(planNodeId, templateActivationMap);
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        HashMap<TRegionReplicaSet, Map> splitMap = new HashMap<TRegionReplicaSet, Map>();
        for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : this.templateActivationMap.entrySet()) {
            TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(entry.getKey().getFullPath());
            splitMap.computeIfAbsent(regionReplicaSet, k -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        ArrayList<WritePlanNode> result = new ArrayList<WritePlanNode>();
        for (Map.Entry entry : splitMap.entrySet()) {
            result.add(new BatchActivateTemplateNode(this.getPlanNodeId(), (Map)entry.getValue(), (TRegionReplicaSet)entry.getKey()));
        }
        return result;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitBatchActivateTemplate(this, context);
    }
}

