/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildProcessNode;

public class HorizontallyConcatNode
extends MultiChildProcessNode {
    public HorizontallyConcatNode(PlanNodeId id) {
        super(id, new ArrayList<PlanNode>());
    }

    public HorizontallyConcatNode(PlanNodeId id, List<PlanNode> children) {
        super(id, children);
    }

    @Override
    public PlanNode clone() {
        return new HorizontallyConcatNode(this.getPlanNodeId());
    }

    @Override
    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        return new HorizontallyConcatNode(new PlanNodeId(String.format("%s-%s", this.getPlanNodeId(), subNodeId)), new ArrayList<PlanNode>(this.children.subList(startIndex, endIndex)));
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.children.stream().map(PlanNode::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitHorizontallyConcat(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.VERTICALLY_CONCAT.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.VERTICALLY_CONCAT.serialize(stream);
    }

    public static HorizontallyConcatNode deserialize(ByteBuffer byteBuffer) {
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new HorizontallyConcatNode(planNodeId);
    }

    public String toString() {
        return "HorizontallyConcatNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontallyConcatNode that = (HorizontallyConcatNode)o;
        return this.children.equals(that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.children);
    }
}

