/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.utils.TimePartitionUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.exception.NotImplementedException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class InsertRowNode
extends InsertNode
implements WALEntryValue {
    private static final byte TYPE_RAW_STRING = -1;
    private static final byte TYPE_NULL = -2;
    private long time;
    private Object[] values;
    private boolean isNeedInferType = false;

    public InsertRowNode(PlanNodeId id) {
        super(id);
    }

    public InsertRowNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, long time, Object[] values, boolean isNeedInferType) {
        super(id, devicePath, isAligned, measurements, dataTypes);
        this.time = time;
        this.values = values;
        this.isNeedInferType = isNeedInferType;
    }

    public InsertRowNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, MeasurementSchema[] measurementSchemas, long time, Object[] values, boolean isNeedInferType) {
        super(id, devicePath, isAligned, measurements, dataTypes);
        this.measurementSchemas = measurementSchemas;
        this.time = time;
        this.values = values;
        this.isNeedInferType = isNeedInferType;
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        TTimePartitionSlot timePartitionSlot = TimePartitionUtils.getTimePartition(this.time);
        this.dataRegionReplicaSet = analysis.getDataPartitionInfo().getDataRegionReplicaSetForWriting(this.devicePath.getFullPath(), timePartitionSlot);
        analysis.setRedirectNodeList(Collections.singletonList(((TDataNodeLocation)this.dataRegionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint()));
        return Collections.singletonList(this);
    }

    @Override
    public List<PlanNode> getChildren() {
        return null;
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of Insert is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public TSDataType[] getDataTypes() {
        if (this.isNeedInferType) {
            TSDataType[] predictedDataTypes = new TSDataType[this.dataTypes.length];
            for (int i = 0; i < this.dataTypes.length; ++i) {
                predictedDataTypes[i] = TypeInferenceUtils.getPredictedDataType(this.values[i], true);
            }
            return predictedDataTypes;
        }
        return this.dataTypes;
    }

    @Override
    public TSDataType getDataType(int index) {
        if (this.isNeedInferType) {
            return TypeInferenceUtils.getPredictedDataType(this.values[index], true);
        }
        return this.dataTypes[index];
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isNeedInferType() {
        return this.isNeedInferType;
    }

    public void setNeedInferType(boolean needInferType) {
        this.isNeedInferType = needInferType;
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        return Collections.singletonList(TimePartitionUtils.getTimePartition(this.time));
    }

    @Override
    public void markFailedMeasurement(int index) {
        if (this.measurements[index] == null) {
            return;
        }
        this.measurements[index] = null;
        this.dataTypes[index] = null;
        this.values[index] = null;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INSERT_ROW.serialize(byteBuffer);
        this.subSerialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INSERT_ROW.serialize(stream);
        this.subSerialize(stream);
    }

    void subSerialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((long)this.time, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((String)this.devicePath.getFullPath(), (ByteBuffer)buffer);
        this.serializeMeasurementsAndValues(buffer);
    }

    void subSerialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((long)this.time, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.devicePath.getFullPath(), (OutputStream)stream);
        this.serializeMeasurementsAndValues(stream);
    }

    void serializeMeasurementsAndValues(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)(this.measurements.length - this.getFailedMeasurementNumber()), (ByteBuffer)buffer);
        this.serializeMeasurementsOrSchemas(buffer);
        this.putDataTypesAndValues(buffer);
        ReadWriteIOUtils.write((byte)((byte)(this.isNeedInferType ? 1 : 0)), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((byte)((byte)(this.isAligned ? 1 : 0)), (ByteBuffer)buffer);
    }

    void serializeMeasurementsAndValues(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)(this.measurements.length - this.getFailedMeasurementNumber()), (OutputStream)stream);
        this.serializeMeasurementsOrSchemas(stream);
        this.putDataTypesAndValues(stream);
        ReadWriteIOUtils.write((byte)((byte)(this.isNeedInferType ? 1 : 0)), (OutputStream)stream);
        ReadWriteIOUtils.write((byte)((byte)(this.isAligned ? 1 : 0)), (OutputStream)stream);
    }

    private void serializeMeasurementsOrSchemas(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)((byte)(this.measurementSchemas != null ? 1 : 0)), (ByteBuffer)buffer);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.measurementSchemas != null) {
                this.measurementSchemas[i].serializeTo(buffer);
                continue;
            }
            ReadWriteIOUtils.write((String)this.measurements[i], (ByteBuffer)buffer);
        }
    }

    private void serializeMeasurementsOrSchemas(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)((byte)(this.measurementSchemas != null ? 1 : 0)), (OutputStream)stream);
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.measurementSchemas != null) {
                this.measurementSchemas[i].serializeTo((OutputStream)stream);
                continue;
            }
            ReadWriteIOUtils.write((String)this.measurements[i], (OutputStream)stream);
        }
    }

    private void putDataTypesAndValues(ByteBuffer buffer) {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.values[i] == null) {
                ReadWriteIOUtils.write((byte)-2, (ByteBuffer)buffer);
                continue;
            }
            if (this.isNeedInferType) {
                ReadWriteIOUtils.write((byte)-1, (ByteBuffer)buffer);
                ReadWriteIOUtils.write((String)this.values[i].toString(), (ByteBuffer)buffer);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)this.dataTypes[i], (ByteBuffer)buffer);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (ByteBuffer)buffer);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    private void putDataTypesAndValues(DataOutputStream stream) throws IOException {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.values[i] == null) {
                ReadWriteIOUtils.write((byte)-2, (OutputStream)stream);
                continue;
            }
            if (this.isNeedInferType) {
                ReadWriteIOUtils.write((byte)-1, (OutputStream)stream);
                ReadWriteIOUtils.write((String)this.values[i].toString(), (OutputStream)stream);
                continue;
            }
            ReadWriteIOUtils.write((TSDataType)this.dataTypes[i], (OutputStream)stream);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ReadWriteIOUtils.write((Boolean)((Boolean)this.values[i]), (OutputStream)stream);
                    continue block8;
                }
                case INT32: {
                    ReadWriteIOUtils.write((int)((Integer)this.values[i]), (OutputStream)stream);
                    continue block8;
                }
                case INT64: {
                    ReadWriteIOUtils.write((long)((Long)this.values[i]), (OutputStream)stream);
                    continue block8;
                }
                case FLOAT: {
                    ReadWriteIOUtils.write((float)((Float)this.values[i]).floatValue(), (OutputStream)stream);
                    continue block8;
                }
                case DOUBLE: {
                    ReadWriteIOUtils.write((double)((Double)this.values[i]), (OutputStream)stream);
                    continue block8;
                }
                case TEXT: {
                    ReadWriteIOUtils.write((Binary)((Binary)this.values[i]), (OutputStream)stream);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public static InsertRowNode deserialize(ByteBuffer byteBuffer) {
        InsertRowNode insertNode = new InsertRowNode(new PlanNodeId(""));
        insertNode.subDeserialize(byteBuffer);
        insertNode.setPlanNodeId(PlanNodeId.deserialize(byteBuffer));
        return insertNode;
    }

    void subDeserialize(ByteBuffer byteBuffer) {
        this.time = byteBuffer.getLong();
        try {
            this.devicePath = new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
        }
        this.deserializeMeasurementsAndValues(byteBuffer);
    }

    void deserializeMeasurementsAndValues(ByteBuffer buffer) {
        boolean hasSchema;
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        boolean bl = hasSchema = buffer.get() == 1;
        if (hasSchema) {
            this.measurementSchemas = new MeasurementSchema[measurementSize];
            for (int i = 0; i < measurementSize; ++i) {
                this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((ByteBuffer)buffer);
                this.measurements[i] = this.measurementSchemas[i].getMeasurementId();
            }
        } else {
            for (int i = 0; i < measurementSize; ++i) {
                this.measurements[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            }
        }
        this.dataTypes = new TSDataType[measurementSize];
        this.values = new Object[measurementSize];
        this.fillDataTypesAndValues(buffer);
        this.isNeedInferType = buffer.get() == 1;
        this.isAligned = buffer.get() == 1;
    }

    private void fillDataTypesAndValues(ByteBuffer buffer) {
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = (byte)ReadWriteIOUtils.read((ByteBuffer)buffer);
            if (typeNum == -1 || typeNum == -2) {
                this.values[i] = typeNum == -1 ? ReadWriteIOUtils.readString((ByteBuffer)buffer) : null;
                continue;
            }
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    @Override
    public long getMinTime() {
        return this.getTime();
    }

    @Override
    public int serializedSize() {
        return 2 + this.subSerializeSize();
    }

    private int subSerializeSize() {
        int size = 0;
        size += 16;
        return (size += ReadWriteIOUtils.sizeToWrite((String)this.devicePath.getFullPath())) + this.serializeMeasurementsAndValuesSize();
    }

    private int serializeMeasurementsAndValuesSize() {
        int size = 0;
        size += 4;
        size += this.serializeMeasurementSchemasSize();
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.values[i] == null) {
                ++size;
                continue;
            }
            ++size;
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    ++size;
                    continue block8;
                }
                case INT32: {
                    size += 4;
                    continue block8;
                }
                case INT64: {
                    size += 8;
                    continue block8;
                }
                case FLOAT: {
                    size += 4;
                    continue block8;
                }
                case DOUBLE: {
                    size += 8;
                    continue block8;
                }
                case TEXT: {
                    size += ReadWriteIOUtils.sizeToWrite((Binary)((Binary)this.values[i]));
                }
            }
        }
        return ++size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putShort(PlanNodeType.INSERT_ROW.getNodeType());
        this.subSerialize(buffer);
    }

    private void subSerialize(IWALByteBufferView buffer) {
        buffer.putLong(this.searchIndex);
        buffer.putLong(this.time);
        WALWriteUtils.write(this.devicePath.getFullPath(), buffer);
        this.serializeMeasurementsAndValues(buffer);
    }

    private void serializeMeasurementsAndValues(IWALByteBufferView buffer) {
        buffer.putInt(this.measurements.length - this.getFailedMeasurementNumber());
        this.serializeMeasurementSchemasToWAL(buffer);
        this.putDataTypesAndValues(buffer);
        buffer.put((byte)(this.isAligned ? 1 : 0));
    }

    private void putDataTypesAndValues(IWALByteBufferView buffer) {
        block8: for (int i = 0; i < this.values.length; ++i) {
            if (this.measurements[i] == null) continue;
            if (this.values[i] == null) {
                WALWriteUtils.write((byte)-2, buffer);
                continue;
            }
            WALWriteUtils.write(this.dataTypes[i], buffer);
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    WALWriteUtils.write((Boolean)this.values[i], buffer);
                    continue block8;
                }
                case INT32: {
                    WALWriteUtils.write((Integer)this.values[i], buffer);
                    continue block8;
                }
                case INT64: {
                    WALWriteUtils.write((Long)this.values[i], buffer);
                    continue block8;
                }
                case FLOAT: {
                    WALWriteUtils.write(((Float)this.values[i]).floatValue(), buffer);
                    continue block8;
                }
                case DOUBLE: {
                    WALWriteUtils.write((Double)this.values[i], buffer);
                    continue block8;
                }
                case TEXT: {
                    WALWriteUtils.write((Binary)this.values[i], buffer);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public static InsertRowNode deserializeFromWAL(DataInputStream stream) throws IOException {
        InsertRowNode insertNode = new InsertRowNode(new PlanNodeId(""));
        insertNode.setSearchIndex(stream.readLong());
        insertNode.setTime(stream.readLong());
        try {
            insertNode.setDevicePath(new PartialPath(ReadWriteIOUtils.readString((InputStream)stream)));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
        }
        insertNode.deserializeMeasurementsAndValuesFromWAL(stream);
        return insertNode;
    }

    void deserializeMeasurementsAndValuesFromWAL(DataInputStream stream) throws IOException {
        int measurementSize = stream.readInt();
        this.measurements = new String[measurementSize];
        this.measurementSchemas = new MeasurementSchema[measurementSize];
        this.dataTypes = new TSDataType[measurementSize];
        this.deserializeMeasurementSchemas(stream);
        this.values = new Object[measurementSize];
        this.fillDataTypesAndValuesFromWAL(stream);
        this.isAligned = stream.readByte() == 1;
    }

    public void fillDataTypesAndValuesFromWAL(DataInputStream stream) throws IOException {
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = stream.readByte();
            if (typeNum == -2) continue;
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((InputStream)stream);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((InputStream)stream);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((InputStream)stream);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((InputStream)stream));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((InputStream)stream);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((InputStream)stream);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public static InsertRowNode deserializeFromWAL(ByteBuffer buffer) {
        InsertRowNode insertNode = new InsertRowNode(new PlanNodeId(""));
        insertNode.setSearchIndex(buffer.getLong());
        insertNode.setTime(buffer.getLong());
        try {
            insertNode.setDevicePath(new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
        }
        insertNode.deserializeMeasurementsAndValuesFromWAL(buffer);
        return insertNode;
    }

    void deserializeMeasurementsAndValuesFromWAL(ByteBuffer buffer) {
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        this.measurementSchemas = new MeasurementSchema[measurementSize];
        this.deserializeMeasurementSchemas(buffer);
        this.dataTypes = new TSDataType[measurementSize];
        this.values = new Object[measurementSize];
        this.fillDataTypesAndValuesFromWAL(buffer);
        this.isAligned = buffer.get() == 1;
    }

    public void fillDataTypesAndValuesFromWAL(ByteBuffer buffer) {
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = buffer.get();
            if (typeNum == -2) continue;
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertRowNode that = (InsertRowNode)o;
        return this.time == that.time && this.isNeedInferType == that.isNeedInferType && Arrays.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.time, this.isNeedInferType);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRow(this, context);
    }

    public TimeValuePair composeTimeValuePair(int columnIndex) {
        if (columnIndex >= this.values.length) {
            return null;
        }
        Object value = this.values[columnIndex];
        return new TimeValuePair(this.time, TsPrimitiveType.getByType((TSDataType)this.dataTypes[columnIndex], (Object)value));
    }
}

