/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum AggregationStep {
    PARTIAL(InputType.RAW, true, 0),
    FINAL(InputType.PARTIAL, false, 1),
    INTERMEDIATE(InputType.PARTIAL, true, 2),
    SINGLE(InputType.RAW, false, 3),
    STATIC(InputType.FINAL, false, 4);

    private final InputType inputType;
    private final boolean outputPartial;
    private final byte ordinal;

    private AggregationStep(InputType inputType, boolean outputPartial, byte ordinal) {
        this.inputType = inputType;
        this.outputPartial = outputPartial;
        this.ordinal = ordinal;
    }

    public boolean isInputRaw() {
        return this.inputType == InputType.RAW;
    }

    public boolean isInputPartial() {
        return this.inputType == InputType.PARTIAL;
    }

    public boolean isInputFinal() {
        return this.inputType == InputType.FINAL;
    }

    public boolean isOutputPartial() {
        return this.outputPartial;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((byte)this.ordinal, (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.ordinal, (OutputStream)stream);
    }

    public static AggregationStep deserialize(ByteBuffer byteBuffer) {
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        switch (type) {
            case 0: {
                return PARTIAL;
            }
            case 1: {
                return FINAL;
            }
            case 2: {
                return INTERMEDIATE;
            }
            case 3: {
                return SINGLE;
            }
            case 4: {
                return STATIC;
            }
        }
        throw new IllegalArgumentException("Invalid AggregationStep type: " + type);
    }

    private static enum InputType {
        RAW,
        PARTIAL,
        FINAL;

    }
}

