/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata.template;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class CreateSchemaTemplateStatement
extends Statement
implements IConfigStatement {
    String name;
    List<String> measurements;
    List<TSDataType> dataTypes;
    List<TSEncoding> encodings;
    List<CompressionType> compressors;
    boolean isAligned;
    private static final int NEW_PLAN = -1;

    public CreateSchemaTemplateStatement() {
        this.statementType = StatementType.CREATE_TEMPLATE;
    }

    public CreateSchemaTemplateStatement(String name, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors, boolean aligned) {
        this();
        this.name = name;
        this.isAligned = aligned;
        if (aligned) {
            this.measurements = measurements.get(0);
            this.dataTypes = dataTypes.get(0);
            this.encodings = encodings.get(0);
            this.compressors = compressors.get(0);
        } else {
            this.measurements = measurements.stream().map(i -> (String)i.get(0)).collect(Collectors.toList());
            this.dataTypes = dataTypes.stream().map(i -> (TSDataType)i.get(0)).collect(Collectors.toList());
            this.encodings = encodings.stream().map(i -> (TSEncoding)i.get(0)).collect(Collectors.toList());
            this.compressors = compressors.stream().map(i -> (CompressionType)i.get(0)).collect(Collectors.toList());
        }
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateSchemaTemplate(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

